class OrderCartModel {

  List<DATA> dATA;

  OrderCartModel({this.dATA});

  OrderCartModel.fromJson(Map<String, dynamic> json) {
    if (json['DATA'] != null) {
      dATA = new List<DATA>();
      json['DATA'].forEach((v) {
        dATA.add(new DATA.fromJson(v));
      });
    }
  }


  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.dATA != null) {
      data['DATA'] = this.dATA.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DATA {
  int id;
  String cartDate;
  dynamic cartExpire;
  dynamic startDate;
  dynamic endDate;
  String createdBy;
  String updatedBy;
  String isGuestCustomer;
  dynamic sessId;
  int userId;
  dynamic vendorTeamId;
  int storeId;
  int vendorId;
  String createdAt;
  String updatedAt;
  List<CartItem> cartItem;

  DATA(
      {this.id,
        this.cartDate,
        this.cartExpire,
        this.startDate,
        this.endDate,
        this.createdBy,
        this.updatedBy,
        this.isGuestCustomer,
        this.sessId,
        this.userId,
        this.vendorTeamId,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.cartItem
      });

  DATA.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    cartDate = json['cart_date'];
    cartExpire = json['cart_expire'];
    startDate = json['start_date'];
    endDate = json['end_date'];
    createdBy = json['created_by'];
    updatedBy = json['updated_by'];
    isGuestCustomer = json['is_guest_customer'];
    sessId = json['sess_id'];
    userId = json['user_id'];
    vendorTeamId = json['vendor_team_id'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    if (json['cart_item'] != null) {
      cartItem = new List<CartItem>();
      json['cart_item'].forEach((v) {
        cartItem.add(new CartItem.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['cart_date'] = this.cartDate;
    data['cart_expire'] = this.cartExpire;
    data['start_date'] = this.startDate;
    data['end_date'] = this.endDate;
    data['created_by'] = this.createdBy;
    data['updated_by'] = this.updatedBy;
    data['is_guest_customer'] = this.isGuestCustomer;
    data['sess_id'] = this.sessId;
    data['user_id'] = this.userId;
    data['vendor_team_id'] = this.vendorTeamId;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    if (this.cartItem != null) {
      data['cart_item'] = this.cartItem.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class CartItem {
  int id;
  int cartId;
  int productId;
  int storeId;
  int vendorId;
  String createdAt;
  String updatedAt;
  dynamic vendorTeamId;
  int qty;
  String addedDate;
  dynamic expireDate;
  Product product;

  CartItem(
      {this.id,
        this.cartId,
        this.productId,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.vendorTeamId,
        this.qty,
        this.addedDate,
        this.expireDate,
        this.product});

  CartItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    cartId = json['cart_id'];
    productId = json['product_id'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    vendorTeamId = json['vendor_team_id'];
    qty = json['qty'];
    addedDate = json['added_date'];
    expireDate = json['expire_date'];
    product =
    json['product'] != null ? new Product.fromJson(json['product']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['cart_id'] = this.cartId;
    data['product_id'] = this.productId;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['vendor_team_id'] = this.vendorTeamId;
    data['qty'] = this.qty;
    data['added_date'] = this.addedDate;
    data['expire_date'] = this.expireDate;
    if (this.product != null) {
      data['product'] = this.product.toJson();
    }
    return data;
  }
}

class Product {
  int id;
  String urlCode;
  String name;
  String cover;
  String excerpt;
  String detail;
  String price;
  String specialPrice;
  String sku;
  dynamic tax;
  int quantity;
  dynamic weight;
  String visibility;
  dynamic newsFromDate;
  dynamic newsToDate;
  dynamic layout;
  dynamic theme;
  String duration;
  dynamic sellingStartTime;
  dynamic sellingEndTime;
  dynamic redemptionStartTime;
  dynamic redemptionEndTime;
  dynamic availibility;
  String isFeatured;
  String isDeal;
  String hasTeam;
  String offpeak;
  String reviewStatus;
  String relatedStatus;
  String upSellsStatus;
  String crossSellsStatus;
  String allowGiftMessage;
  String stockStatus;
  String status;
  int businessTypeId;
  int businessCateId;
  dynamic businessServiceId;
  int attributeSetId;
  int vendorId;
  String allowRoute;
  dynamic type;
  int star;
  List<Null> ratings;

  Product(
      {this.id,
        this.urlCode,
        this.name,
        this.cover,
        this.excerpt,
        this.detail,
        this.price,
        this.specialPrice,
        this.sku,
        this.tax,
        this.quantity,
        this.weight,
        this.visibility,
        this.newsFromDate,
        this.newsToDate,
        this.layout,
        this.theme,
        this.duration,
        this.sellingStartTime,
        this.sellingEndTime,
        this.redemptionStartTime,
        this.redemptionEndTime,
        this.availibility,
        this.isFeatured,
        this.isDeal,
        this.hasTeam,
        this.offpeak,
        this.reviewStatus,
        this.relatedStatus,
        this.upSellsStatus,
        this.crossSellsStatus,
        this.allowGiftMessage,
        this.stockStatus,
        this.status,
        this.businessTypeId,
        this.businessCateId,
        this.businessServiceId,
        this.attributeSetId,
        this.vendorId,
        this.allowRoute,
        this.type,
        this.star,
        this.ratings});

  Product.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    urlCode = json['url_code'];
    name = json['name'];
    cover = json['cover'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    price = json['price'];
    specialPrice = json['special_price'];
    sku = json['sku'];
    tax = json['tax'];
    quantity = json['quantity'];
    weight = json['weight'];
    visibility = json['visibility'];
    newsFromDate = json['news_from_date'];
    newsToDate = json['news_to_date'];
    layout = json['layout'];
    theme = json['theme'];
    duration = json['duration'];
    sellingStartTime = json['selling_start_time'];
    sellingEndTime = json['selling_end_time'];
    redemptionStartTime = json['redemption_start_time'];
    redemptionEndTime = json['redemption_end_time'];
    availibility = json['availibility'];
    isFeatured = json['is_featured'];
    isDeal = json['is_deal'];
    hasTeam = json['has_team'];
    offpeak = json['offpeak'];
    reviewStatus = json['review_status'];
    relatedStatus = json['related_status'];
    upSellsStatus = json['up_sells_status'];
    crossSellsStatus = json['cross_sells_status'];
    allowGiftMessage = json['allow_gift_message'];
    stockStatus = json['stock_status'];
    status = json['status'];
    businessTypeId = json['business_type_id'];
    businessCateId = json['business_cate_id'];
    businessServiceId = json['business_service_id'];
    attributeSetId = json['attribute_set_id'];
    vendorId = json['vendor_id'];
    allowRoute = json['allow_route'];
    type = json['type'];
    star = json['star'];
    // if (json['ratings'] != null) {
    //   ratings = new List<Null>();
    //   json['ratings'].forEach((v) {
    //     ratings.add(new Null.fromJson(v));
    //   });
    // }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['url_code'] = this.urlCode;
    data['name'] = this.name;
    data['cover'] = this.cover;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['price'] = this.price;
    data['special_price'] = this.specialPrice;
    data['sku'] = this.sku;
    data['tax'] = this.tax;
    data['quantity'] = this.quantity;
    data['weight'] = this.weight;
    data['visibility'] = this.visibility;
    data['news_from_date'] = this.newsFromDate;
    data['news_to_date'] = this.newsToDate;
    data['layout'] = this.layout;
    data['theme'] = this.theme;
    data['duration'] = this.duration;
    data['selling_start_time'] = this.sellingStartTime;
    data['selling_end_time'] = this.sellingEndTime;
    data['redemption_start_time'] = this.redemptionStartTime;
    data['redemption_end_time'] = this.redemptionEndTime;
    data['availibility'] = this.availibility;
    data['is_featured'] = this.isFeatured;
    data['is_deal'] = this.isDeal;
    data['has_team'] = this.hasTeam;
    data['offpeak'] = this.offpeak;
    data['review_status'] = this.reviewStatus;
    data['related_status'] = this.relatedStatus;
    data['up_sells_status'] = this.upSellsStatus;
    data['cross_sells_status'] = this.crossSellsStatus;
    data['allow_gift_message'] = this.allowGiftMessage;
    data['stock_status'] = this.stockStatus;
    data['status'] = this.status;
    data['business_type_id'] = this.businessTypeId;
    data['business_cate_id'] = this.businessCateId;
    data['business_service_id'] = this.businessServiceId;
    data['attribute_set_id'] = this.attributeSetId;
    data['vendor_id'] = this.vendorId;
    data['allow_route'] = this.allowRoute;
    data['type'] = this.type;
    data['star'] = this.star;
    // if (this.ratings != null) {
    //   data['ratings'] = this.ratings.map((v) => v.toJson()).toList();
    // }
    return data;
  }
}
