class LoginModel {
  String token;
  int expires;
  User user;

  LoginModel({this.token, 
  this.expires,
  this.user
   });

  LoginModel.fromJson(Map<String, dynamic> json) {
    token = json['token'];
    expires = json['expires'];
   user = json['user'] != null ? new User.fromJson(json['user']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['token'] = this.token;
   data['expires'] = this.expires;
    if (this.user != null) {
      data['user'] = this.user.toJson();
    }
    return data;
  }
}

class User {
  int id;
  String roleId;
  String name;
  String email;
  String avatar;
  String emailVerifiedAt;
  int status;
  int fvRoleId;
  String settings;
  String createdAt;
  String updatedAt;
  String customerInfo;

  User(
      {this.id,
      this.roleId,
      this.name,
      this.email,
      this.avatar,
      this.emailVerifiedAt,
      this.status,
      this.fvRoleId,
      this.settings,
      this.createdAt,
      this.updatedAt,
      this.customerInfo});

  User.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    roleId = json['role_id'];
    name = json['name'];
    email = json['email'];
    avatar = json['avatar'];
    emailVerifiedAt = json['email_verified_at'];
    status = json['status'];
    fvRoleId = json['fv_role_id'];
    settings = json['settings'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    customerInfo = json['customer_info'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id']= this.id;
    data['role_id']==null?[]: data['role_id']  = this.roleId;
    data['name'] = this.name;
    data['email'] = this.email;
    data['avatar'] = this.avatar;
    data['email_verified_at']==null?[]: data['email_verified_at'] = this.emailVerifiedAt;
    data['status'] = this.status;
    data['fv_role_id'] = this.fvRoleId;
    data['settings']==null?[]: data['settings']  = this.settings;
    data['created_at']==null?[]: data['created_at']  = this.createdAt;
    data['updated_at']==null?[]: data['updated_at']  = this.updatedAt;
    data['customer_info']==null?[]: data['customer_info']  = this.customerInfo;
    return data;
  }
}