class LoginModel {
  String token;
  int expires;
  User user;

  LoginModel({this.token, this.expires, this.user});

  LoginModel.fromJson(Map<String, dynamic> json) {
    token = json['token'];
    expires = json['expires'];
    user = json['user'] != null ? new User.fromJson(json['user']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['token'] = this.token;
    data['expires'] = this.expires;
    if (this.user != null) {
      data['user'] = this.user.toJson();
    }
    return data;
  }
}

class User {
  int id;
  dynamic roleId;
  String name;
  String email;
  String avatar;
  dynamic emailVerifiedAt;
  int status;
  int fvRoleId;
  dynamic settings;
  dynamic createdAt;
  dynamic updatedAt;
  CustomerInfo customerInfo;

  User(
      {this.id,
      this.roleId,
      this.name,
      this.email,
      this.avatar,
      this.emailVerifiedAt,
      this.status,
      this.fvRoleId,
      this.settings,
      this.createdAt,
      this.updatedAt,
      this.customerInfo});

  User.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    roleId = json['role_id'];
    name = json['name'];
    email = json['email'];
    avatar = json['avatar'];
    emailVerifiedAt = json['email_verified_at'];
    status = json['status'];
    fvRoleId = json['fv_role_id'];
    settings = json['settings'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    customerInfo = json['customer_info'] != null
        ? new CustomerInfo.fromJson(json['customer_info'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['role_id'] = this.roleId;
    data['name'] = this.name;
    data['email'] = this.email;
    data['avatar'] = this.avatar;
    data['email_verified_at'] = this.emailVerifiedAt;
    data['status'] = this.status;
    data['fv_role_id'] = this.fvRoleId;
    data['settings'] = this.settings;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    if (this.customerInfo != null) {
      data['customer_info'] = this.customerInfo.toJson();
    }
    return data;
  }
}

class CustomerInfo {
  int id;
  String prefix;
  String name;
  String lastname;
  String displayName;
  String image;
  String email;
  String age;
  String sex;
  String phone;
  String address;
  String socialRegister;
  String socialType;
  String status;
  String approved;
  String createdAt;
  String updatedAt;
  int userId;

  CustomerInfo(
      {this.id,
      this.prefix,
      this.name,
      this.lastname,
      this.displayName,
      this.image,
      this.email,
      this.age,
      this.sex,
      this.phone,
      this.address,
      this.socialRegister,
      this.socialType,
      this.status,
      this.approved,
      this.createdAt,
      this.updatedAt,
      this.userId});

  CustomerInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    prefix = json['prefix'];
    name = json['name'];
    lastname = json['lastname'];
    displayName = json['display_name'];
    image = json['image'];
    email = json['email'];
    age = json['age'];
    sex = json['sex'];
    phone = json['phone'];
    address = json['address'];
    socialRegister = json['social_register'];
    socialType = json['social_type'];
    status = json['status'];
    approved = json['approved'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    userId = json['user_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['prefix'] = this.prefix;
    data['name'] = this.name;
    data['lastname'] = this.lastname;
    data['display_name'] = this.displayName;
    data['image'] = this.image;
    data['email'] = this.email;
    data['age'] = this.age;
    data['sex'] = this.sex;
    data['phone'] = this.phone;
    data['address'] = this.address;
    data['social_register'] = this.socialRegister;
    data['social_type'] = this.socialType;
    data['status'] = this.status;
    data['approved'] = this.approved;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['user_id'] = this.userId;
    return data;
  }
}
