import 'package:feelverapp/ui/booking/bookingflow.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';


class ReserveDateTime extends StatefulWidget {
  @override
  _ReserveDateTimeState createState() => _ReserveDateTimeState();
}

class _ReserveDateTimeState extends State<ReserveDateTime> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        height: SizeConfig.getHeight(100),
        color: Color.fromRGBO(106, 179, 170, 1),
        child: Stack(
          children: <Widget>[
            Positioned(
              top: SizeConfig.getPadding(24),
              left: SizeConfig.getPadding(20),
              child: Container(
//                color: Colors.red,
                width: MediaQuery.of(context).size.width / 2.5,
                height: SizeConfig.getHeight(45),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(24),
                  color: Color.fromRGBO(54, 148, 163, 1),
                ),
                child: Container(
                  padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                  child: Text(
                    'หยิบใส่รถเข็น',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(20),
              child: InkWell(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => BookingFlow(),
                    ),
                  );
                },
                child: Container(
//                color: Colors.red,
                  width: MediaQuery.of(context).size.width / 2.5,
                  height: SizeConfig.getHeight(45),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(24),
                    color: Color.fromRGBO(232, 166, 180, 1),
                  ),
                  child: Container(
                    padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                    child: Text(
                      'จองเลย',
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          color: Colors.white,
                          fontSize: SizeConfig.getFontSize(14),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Image.network(
                'https://www.cancurreu.com/wp-content/uploads/can_curreu_hotel_ibiza_spa_tratamientos.jpg',
                width: MediaQuery.of(context).size.width,
                fit: BoxFit.cover,
              ),
              Positioned(
                top: SizeConfig.getPadding(44),
                left: SizeConfig.getPadding(16),
                child: InkWell(
                  onTap: () {
                    Navigator.pop(context);
                  },
                  child: Image.asset(
                    'assets/images/ic_back.png',
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getWidth(20),
                  ),
                ),
              )
            ],
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(16)),
            alignment: Alignment.topLeft,
            child: Text(
              'คุณกำลังจอง',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Color.fromRGBO(106, 179, 170, 1),
                  fontSize: SizeConfig.getFontSize(14),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(3),
                bottom: SizeConfig.getPadding(8)),
            alignment: Alignment.topLeft,
            child: Text(
              'Thai Body',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(26),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              Image.asset(
                'assets/images/clock.png',
                width: SizeConfig.getWidth(20),
                height: SizeConfig.getWidth(20),
              ),
              SizedBox(
                width: SizeConfig.getWidth(10),
              ),
              Text(
                '90 นาที',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Colors.black87,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ],
          ),
          SizedBox(
            height: 8,
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(22),
              ),
              Text(
                '฿599.00',
                textAlign: TextAlign.left,
                style: TextStyle(
                    decoration: TextDecoration.lineThrough,
                    color: Colors.black54,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(253, 41, 86, 1),
                    fontSize: SizeConfig.getFontSize(22),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ],
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(8),
                bottom: SizeConfig.getPadding(8)),
            alignment: Alignment.topLeft,
            child: Text(
              'ระบุวันที่ เวลาที่ต้องการนัดหมายเข้าใช้ปริการ',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.getFontSize(14),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          _formDate(),
        ],
      ),
    );
  }

  Widget _formDate() {
    return Container(
      child: Form(
        child: Column(
          children: <Widget>[
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30),top: SizeConfig.getPadding(24)),
              child: Text(
                'ระบุวันที่เข้าใช้บริการ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(
//                  controller: loginBloc.emailCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'ระบุเวลาที่เข้าใช้บริการ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
//                  controller: loginBloc.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(30),
            ),
          ],
        ),
      ),
    );
  }

}
