import 'package:feelverapp/ui/nearme/near_me_detail.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class NearmeList extends StatefulWidget {
  @override
  _NearmeListState createState() => _NearmeListState();
}

class _NearmeListState extends State<NearmeList> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromRGBO(106, 179, 170, 1),
        elevation: 0,
        centerTitle: true,
        title: Text(
          'สถานที่ใกล้เคียงทั้งหมด',
          style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(20),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),
        ),
      ),
      body: _setupView(),
    );
  }

  _setupView() {
    return Stack(
      children: <Widget>[
        Container(
          height: SizeConfig.getWidth(110),
          color: Color.fromRGBO(106, 179, 170, 1),
          child: Container(
            padding: EdgeInsets.only(left: SizeConfig.getPadding(24)),
            alignment: Alignment.topLeft,
            child: Wrap(
              alignment: WrapAlignment.start,
              spacing: 10.0, // gap between adjacent chips
              runSpacing: 5.0, // gap between lines
              children: <Widget>[
                FilterChip(
                  label: Text(
                    "ทั้งหมด (10)",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                    setState(() {});
                  },
                ),
                FilterChip(
                  label: Text(
                    "ที่เที่ยว (5)",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
                FilterChip(
                  label: Text(
                    "ที่กิน (3)",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
                FilterChip(
                  label: Text(
                    "ที่พัก (1)",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
                FilterChip(
                  label: Text(
                    "กิจกรรม (1)",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
              ],
            ),
          ),
        ),
        _getlist(),
      ],
    );
  }

  _getlist() {
    final List<String> entries = <String>['A', 'B', 'C'];
    return Container(
      padding: EdgeInsets.only(
        top: SizeConfig.getPadding(140),
        left: SizeConfig.getPadding(16),
        right: SizeConfig.getPadding(16),
        bottom: SizeConfig.getPadding(10),
      ),
      child: ListView.builder(
        itemCount: entries.length,
        itemBuilder: (context, i) {
          return _nearByItem(entries[i]);
        },
      ),
    );
  }

  Widget _nearByItem(String title) {
    return InkWell(
      onTap: () {
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (context) => NearmeDetail(),
          ),
        );
      },      child: Card(
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: <Widget>[
            Image.network(
              'https://scontent.fbkk2-8.fna.fbcdn.net/v/t1.0-9/66224920_2384272051596091_1094623379467534336_n.jpg?_nc_cat=102&_nc_sid=85a577&_nc_eui2=AeElfU4QES6XQW0XzlV5G9zQ-F-e_QdADw_4X579B0APD-UJsAV-PuXX-iMA6hWVLgUUmCNm5HTgTMw_q4YARQm8&_nc_ohc=do7yQl7hf74AX8-8Yk-&_nc_ht=scontent.fbkk2-8.fna&oh=140482c64ecf1893bf59498dfff5f592&oe=5EFAC9CF',
              width: SizeConfig.getWidth(110),
              height: SizeConfig.getHeight(150),
              fit: BoxFit.fitWidth,
            ),
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    child: Text(
                      'ซีไลฟ์ แบงคอก โอเชียน เวิลด์',
                      style: TextStyle(
                          color: Colors.black87,
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w700),
                    ),
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(16),
                        left: SizeConfig.getPadding(16),
                        right: SizeConfig.getPadding(16),
                        bottom: SizeConfig.getPadding(4)),
                  ),
                  Container(
                    child: Text(
                      'พิพิธภัณฑ์สัตว์น้ำ',
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
//                  alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(0),
                        left: SizeConfig.getPadding(16),
                        bottom: SizeConfig.getPadding(4)),
                  ),
                  Row(
                    children: <Widget>[
                      SizedBox(
                        width: SizeConfig.getWidth(16),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/pin_drop.png'),
                        color: Colors.black54,
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(4),
                      ),
                      Text(
                        '54 km',
                        style: TextStyle(
                          fontWeight: FontWeight.w500,
                          fontSize: SizeConfig.getFontSize(12),
                          color: Colors.black54,
                        ),
                      ),
                    ],
                  ),
                  Container(
                    child: Text(
                      'พิพิธภัณฑ์สัตว์น้ำ ซี ไลฟ์ โอเชียน เวิลด์ กรุงเทพ หรือ บางกอก ซี ไลฟ์ โอเชียนเวิลด์...',
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
//                  alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(8),
                        left: SizeConfig.getPadding(16),
                        bottom: SizeConfig.getPadding(0)),
                  ),
                  Row(
                    children: <Widget>[
                      SizedBox(
                        width: SizeConfig.getWidth(4),
                      ),
                      Container(
                        alignment: Alignment.topLeft,
                        child: Text(
                          '4.4',
                          textAlign: TextAlign.left,
                          style: TextStyle(
                              color: Colors.black54,
                              fontSize: SizeConfig.getFontSize(14),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        padding: EdgeInsets.only(
                            top: SizeConfig.getPadding(5),
                            left: SizeConfig.getPadding(10),
                            bottom: SizeConfig.getPadding(5)),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(14),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_unactive.png'),
                        color: Colors.grey,
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(40),
                        height: SizeConfig.getWidth(30),
                      ),
                    ],
                  ), SizedBox(
                    height: SizeConfig.getWidth(10),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
