import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class NearmeDetail extends StatefulWidget {
  @override
  _NearmeDetailState createState() => _NearmeDetailState();
}

class _NearmeDetailState extends State<NearmeDetail> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
//      appBar: AppBar(
//        backgroundColor: Colors.transparent,
//        elevation: 0,
//        centerTitle: true,
//        title: Text(
//          'k',
//          style: TextStyle(
//              color: Colors.white,
//              fontSize: SizeConfig.getFontSize(20),
//              fontFamily: "SF_Pro_Text",
//              fontWeight: FontWeight.w500),
//        ),
//      ),
      body: _setupView(),
    );
  }

  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Container(
                height: SizeConfig.getWidth(460),
                child: Image.network(
                  'https://wallup.net/wp-content/uploads/2017/03/27/380781-portrait_display-abstract-digital_art-geometry-triangle-lines-748x1330.jpg',
                  width: double.maxFinite,
                  fit: BoxFit.fitWidth,
                ),
              ),
              Positioned(
                top: SizeConfig.getPadding(44),
                left: SizeConfig.getPadding(16),
                child: InkWell(
                  onTap: () {
                    Navigator.pop(context);
                  },
                  child: Image.asset(
                    'assets/images/ic_back.png',
                    width: 14,
                  ),
                ),
              ),
              Container(
                padding: EdgeInsets.only(
                  top: SizeConfig.getPadding(440),
                  right: SizeConfig.getPadding(0),
                  left: SizeConfig.getPadding(
                      MediaQuery.of(context).size.width / 1.6),
                ),
                child: Stack(
                  children: <Widget>[
                    Image.asset(
                      'assets/images/btn_nav.png',
                      width: SizeConfig.getWidth(120),
                    ),
                    Container(
                      child: Text(
                        'นำทาง',
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            color: Colors.white,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                      padding: EdgeInsets.only(
                          top: SizeConfig.getPadding(7),
                          left: SizeConfig.getPadding(26),
                          bottom: SizeConfig.getPadding(4)),
                    ),
                  ],
                ),
              ),
            ],
          ),
          Column(
            children: <Widget>[
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  '4 ธ.ค. 2561 18:55 น.',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.grey,
                      fontSize: SizeConfig.getFontSize(14),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(16),
                    left: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(0)),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  'Sea Life Bangkok Ocean World',
                  style: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(40),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w600),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(10),
                    left: SizeConfig.getPadding(16),
                    right: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(4)),
              ),
              Row(
                children: <Widget>[
                  SizedBox(
                    width: SizeConfig.getWidth(14),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_unactive.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(40),height: SizeConfig.getWidth(30),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_fav_active.png'),
                    color: Colors.pink,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(8),
                  ),
                  Container(alignment: Alignment.topLeft,
                    child: Text(
                      '70',
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(5),
                        left: SizeConfig.getPadding(0),
                        bottom: SizeConfig.getPadding(4)),
                  ),SizedBox(
                    width: SizeConfig.getWidth(20),
                  ),ImageIcon(
                    AssetImage('assets/images/ic_comment.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(8),
                  ),
                  Container(alignment: Alignment.topLeft,
                    child: Text(
                      '70',
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(5),
                        left: SizeConfig.getPadding(0),
                        bottom: SizeConfig.getPadding(4)),
                  ),SizedBox(
                    width: SizeConfig.getWidth(20),
                  ),ImageIcon(
                    AssetImage('assets/images/facebook-icon.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(20),
                  ),ImageIcon(
                    AssetImage('assets/images/ic_twitter.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                ],
              ),
              SizedBox(
                height: SizeConfig.getWidth(8),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  'พิพิธภัณฑ์สัตว์น้ำ',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.grey,
                      fontSize: SizeConfig.getFontSize(14),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(0),
                    left: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(10)),
              ),
              Row(
                children: <Widget>[
                  SizedBox(
                    width: SizeConfig.getWidth(14),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/pin_drop.png'),
                    color: Colors.black54,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(4),
                  ),
                  Text(
                    '54 km',
                    style: TextStyle(
                      fontWeight: FontWeight.w500,
                      fontSize: SizeConfig.getFontSize(14),
                      color: Colors.black54,
                    ),
                  ),
                ],
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  'ที่อยู่: 991 ถนน พระรามที่ ๑ แขวง ปทุมวัน เขต ปทุมวัน กรุงเทพมหานคร 10330',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.grey,
                      fontSize: SizeConfig.getFontSize(14),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
//                  alignment: Alignment.topLeft,
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(8),
                    left: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(10)),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  'พิพิธภัณฑ์สัตว์น้ำ ซี ไลฟ์ โอเชียน เวิลด์ กรุงเทพ หรือ บางกอก ซี ไลฟ์ โอเชียนเวิลด์ (อังกฤษ: Sea Life Bangkok Ocean World; ชื่อเดิม: สยามโอเชียนเวิลด์) เป็นพิพิธภัณฑ์สัตว์น้ำใต้ดิน พื้นที่รวม 10,000 ตาราง เมตร ตั้งอยู่ที่ชั้น B1 และ B2 ศูนย์การค้าสยามพารากอน บริหารงานโดย เมอร์ลิน เอ็นเตอร์เทนเมนท์ กรุ๊ป เปิดให้เข้าชมครั้งแรกเมื่อวันที่ 9 ธันวาคม พ.ศ. 2548 พิพิธภัณฑ์สัตว์น้ำ ซี ไลฟ์ โอเชียน เวิลด์ กรุงเทพ หรือ บางกอก ซี ไลฟ์ โอเชียนเวิลด์ (อังกฤษ: Sea Life Bangkok Ocean World; ชื่อเดิม: สยามโอเชียนเวิลด์) เป็นพิพิธภัณฑ์สัตว์น้ำใต้ดิน พื้นที่รวม 10,000 ตารางเมตร ตั้งอยู่ที่ชั้น B1 และ B2 ศูนย์การค้าสยามพารากอน บริหารงานโดย เมอร์ลิน เอ็นเตอร์เทนเมนท์ กรุ๊ป เปิดให้เข้าชมครั้งแรกเมื่อวันที่ 9 ธันวาคม พ.ศ. 2548',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
//                  alignment: Alignment.topLeft,
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(16),
                    left: SizeConfig.getPadding(16),
                    right: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(30)),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
