import 'package:feelverapp/ui/edit_profile/edit_profile.dart';
import 'package:feelverapp/ui/login/login.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class NavDrawer extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding:  EdgeInsets.only(right: SizeConfig.getPadding(80)),
      child: Drawer(
        elevation: 10,
        child: SingleChildScrollView(
          child: Column(
            children: <Widget>[
              Stack(
                children: <Widget>[
                  Container(
                    padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(10),
                        top: SizeConfig.getPadding(24)),
                    child: Image.asset(
                      'assets/images/ic_userimg.png',
                      width: SizeConfig.getWidth(100),
                      height: SizeConfig.getWidth(100),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(90),
                        top: SizeConfig.getPadding(100)),
                    child: Image.asset(
                      'assets/images/ic_camera.png',
                      width: SizeConfig.getWidth(30),
                      height: SizeConfig.getWidth(30),
                    ),
                  ),
                ],
              ),
              Container(
                padding: EdgeInsets.only(
                  top: SizeConfig.getPadding(20),
                ),
                alignment: Alignment.center,
                child: Text(
                  'John wick',
                  style: TextStyle(
                      color: Colors.black,
                      fontSize: SizeConfig.getFontSize(24),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w600),
                ),
              ),
              Container(
                margin: EdgeInsets.only(
                    left: SizeConfig.getPadding(50),
                    right: SizeConfig.getPadding(50),
                    top: SizeConfig.getPadding(20)),
                height: SizeConfig.getWidth(1),
                color: Colors.grey,
              ),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                      context,
                      CupertinoPageRoute(builder: (context) => EditProfile(),),
                    );
                },
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(24),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'Profile',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {},
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'My favorite',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {},
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'My order Status',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {},
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'รายการสั่งซื้อที่สำเร็จ',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {},
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'จองแล้ว',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {},
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'ยังไม่ได้จอง',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {},
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'รายการสั่งซื้อไม่สำเร็จ',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              Container(
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(30),
                    left: SizeConfig.getPadding(30)),
                alignment: Alignment.topLeft,
                child: Text(
                  'language',
                  style: TextStyle(
                      color: Colors.black,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w600),
                ),
              ),
              Row(
                children: <Widget>[
                  Container(
                    padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(30),
                        top: SizeConfig.getPadding(16)),
                    child: Image.asset(
                      'assets/images/ic_th.png',
                      width: SizeConfig.getWidth(50),
                      height: SizeConfig.getWidth(50),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(30),
                        top: SizeConfig.getPadding(16)),
                    child: Image.asset(
                      'assets/images/ic_en.png',
                      width: SizeConfig.getWidth(50),
                      height: SizeConfig.getWidth(50),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(30),
                        top: SizeConfig.getPadding(16)),
                    child: Image.asset(
                      'assets/images/ic_ch.png',
                      width: SizeConfig.getWidth(50),
                      height: SizeConfig.getWidth(50),
                    ),
                  ),
                ],
              ),
              Row(
                children: <Widget>[
                  Container(
                    padding: EdgeInsets.only(
                        top: 0, left: SizeConfig.getPadding(42)),
                    alignment: Alignment.topLeft,
                    child: Text(
                      'TH',
                      style: TextStyle(
                          color: Colors.black,
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w600),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                        top: 0, left: SizeConfig.getPadding(60)),
                    alignment: Alignment.topLeft,
                    child: Text(
                      'EN',
                      style: TextStyle(
                          color: Colors.black,
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w600),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                        top: 0, left: SizeConfig.getPadding(60)),
                    alignment: Alignment.topLeft,
                    child: Text(
                      'CH',
                      style: TextStyle(
                          color: Colors.black,
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w600),
                    ),
                  ),
                ],
              ),
              Row(
                children: <Widget>[
                  Container(
                    padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(30),
                        top: SizeConfig.getPadding(30)),
                    child: Image.asset(
                      'assets/images/ic_logout.png',
                      width: SizeConfig.getWidth(20),
                      height: SizeConfig.getWidth(20),
                    ),
                  ),
                  GestureDetector(
                    onTap: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => LoginPage()),
                      );
                    },
                    child: Container(
                      padding: EdgeInsets.only(
                          top: SizeConfig.getPadding(26),
                          left: SizeConfig.getPadding(18)),
                      alignment: Alignment.topLeft,
                      child: Text(
                        'ออกจากระบบ',
                        style: TextStyle(
                            color: Colors.black,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w600),
                      ),
                    ),
                  )
                ],
              ),
              SizedBox(
                height: SizeConfig.getWidth(40),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
