import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class EditProfile extends StatefulWidget {
  @override
  _EditProfileState createState() => _EditProfileState();
}

class _EditProfileState extends State<EditProfile> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromRGBO(106, 179, 170, 1),
        elevation: 0,
        centerTitle: true,
        title: Text(
          'แก้ไขโปรไฟล์',
          style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(20),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),
        ),
      ),
      body: SingleChildScrollView(
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                Container(
                  height: SizeConfig.getWidth(80),
                  color: Color.fromRGBO(106, 179, 170, 1),
                ),
                Container(
                  alignment: Alignment.topCenter,
                  padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(10),
                      top: SizeConfig.getPadding(30)),
                  child: Image.asset(
                    'assets/images/ic_userimg.png',
                    width: SizeConfig.getWidth(100),
                    height: SizeConfig.getWidth(100),
                  ),
                ),
                Container(
                  alignment: Alignment.topCenter,
                  padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(10),
                      top: SizeConfig.getPadding(65)),
                  child: Image.asset(
                    'assets/images/ic_camera_profile.png',
                    width: SizeConfig.getWidth(34),
                    height: SizeConfig.getWidth(34),
                  ),
                ),
              ],
            ),
            Container(
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(10),
                top: SizeConfig.getPadding(10),
              ),
              child: Text(
                'Rattaya Pratumkan',
                style: TextStyle(
                    color: Color.fromRGBO(238, 175, 183, 1),
                    fontSize: SizeConfig.getFontSize(24),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(0),
              ),
              child: TextFormField(
                decoration: InputDecoration(
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.black45),
                  ) ,
                  labelText: 'ชื่อผู้ใช้งาน',
                  labelStyle: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
              ),
            ) ,         Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(0),
              ),
              child: TextFormField(
                decoration: InputDecoration(
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.black45),
                  ),
                  hintText: '',
                  labelText: 'เพศ',
                  labelStyle: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                  focusColor: Colors.red,
                ),
              ),
            ),          Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(0),
              ),
              child: TextField(
                decoration: InputDecoration(
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.black45),
                  ),
                  hintText: '',
                  labelText: 'วัน เดือน ปีเกิด',
                  labelStyle: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                  focusColor: Colors.red,
                ),
              ),
            ),          Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(0),
              ),
              child: TextFormField(
                decoration: InputDecoration(
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.black45),
                  ),
                  hintText: '',
                  labelText: 'เบอร์โทร',
                  labelStyle: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                  focusColor: Colors.red,
                ),
              ),
            ),          Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(0),
              ),
              child: TextFormField(
                decoration: InputDecoration(
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.black45),
                  ),
                  hintText: '',
                  labelText: 'อีเมล์',
                  labelStyle: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                  focusColor: Colors.red,
                ),
              ),
            ),Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(0),
              ),
              child: TextFormField(
                decoration: InputDecoration(
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.black45),
                  ),
                  hintText: '',
                  labelText: 'ที่อยู่',
                  labelStyle: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                  focusColor: Colors.red,
                ),
              ),
            ),Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(0),
              ),
              child: TextFormField(
                decoration: InputDecoration(
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.black45),
                  ),
                  hintText: '',
                  labelText: 'ข้อมูลบัญชีธนาคาร',
                  labelStyle: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                  focusColor: Colors.red,
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }


}
