import 'dart:io';

import 'package:objectdb/objectdb.dart';
import 'package:path_provider/path_provider.dart' as path;

class DatabaseUtil<T>{
  Future<ObjectId> insertData({String dbName, data}) async {
    final directory = await path.getApplicationDocumentsDirectory();
    final filePath = [directory.path, '$dbName.db'].join('/');
    final db = ObjectDB(filePath);

    db.open();

    db.remove({});

    ObjectId id = await db.insert(data.toJson());

    db.close();

    return id;
  }

  Future<List<Map>> selectData({String dbName, Map query,dynamic data}) async {
    final directory = await path.getApplicationDocumentsDirectory();
    final filePath = [directory.path, '$dbName.db'].join('/');
    final db = ObjectDB(filePath);

    db.open();

    var data = await db.find(query);

    db.close();

    return data;
  }

  Future<List<Map>> selectAllData({String dbName, dynamic data}) async {
    final directory = await path.getApplicationDocumentsDirectory();
    final filePath = [directory.path, '$dbName.db'].join('/');
    final db = ObjectDB(filePath);

    db.open();

    var data = await db.find({});

    db.close();

    return data;
  }

  removeAll({String dbName}) async {
    final directory = await path.getApplicationDocumentsDirectory();
    final filePath = [directory.path, '$dbName.db'].join('/');
    final db = ObjectDB(filePath);

    db.open();

    db.remove({});

    db.close();
  }
}