import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:tuoc/environment/base_presenter.dart';
import 'package:tuoc/model/my_profile/my_profile.dart';
import 'package:tuoc/page/edit_profile/edit_profile_page.dart';
import 'package:tuoc/page/login/login_page.dart';
import 'package:tuoc/page/profile/profile_page.dart';
import 'package:tuoc/util/account_util.dart';
import 'package:tuoc/util/loading.dart';

class ProfilePresenter extends BasePresenter<ProfilePage>{
  List<MyProfileDataModel> data = [];

  ProfilePresenter(State<ProfilePage> state) : super(state){
    Future.delayed(Duration.zero, () => _initPage());
  }

  _initPage() async{
    loading();
    Loading(state.context).show();
    await _getProfile();
    Loading(state.context).hide();
    loaded();
  }

  Future<void> _getProfile() async{
    data = [];
    var res = await AccountUtil.getProfile();
    setState((){
      data = res;
    });
  }

  Future<void> gotoEditProfile() async {
    await Navigator.push(state.context, CupertinoPageRoute(builder: (_) => EditProfilePage()));
    _initPage();
  }

  logout() async {
    await AccountUtil.removeAccessToken();
    Navigator.popUntil(state.context, (r) => r.isFirst);
    Navigator.pushReplacement(state.context, MaterialPageRoute(builder: (_) => LoginPage()));
  }

}