import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:peasmartcare/constraints/image_asset.dart';

class ImageBox extends StatelessWidget {
  final String name;
  final String src;
  final BorderRadius borderRadius;
  final double height;
  final double width;
  final BoxFit fit;

  const ImageBox({
    Key key,
    this.name = "Not Found",
    this.src,
    this.borderRadius,
    this.height,
    this.width,
    this.fit,
  }) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Container(
      alignment: Alignment.topCenter,
      height: height,
      width: width,
      decoration: BoxDecoration(
        borderRadius: borderRadius,//BorderRadius.only(topLeft: Radius.circular(3), bottomLeft: Radius.circular(3)),
        image: DecorationImage(
          image: (src != null && src != "") ? CachedNetworkImageProvider(src) : AssetImage(ImageAsset.imageNotFound),
          fit: fit !=null? fit : BoxFit.cover,
        ),
      ),
    );
  }
}
