import 'package:cloud_firestore/cloud_firestore.dart';
import 'package:dash_chat/dash_chat.dart';
import 'package:peasmartcare/constraints/app_data.dart';

class FirestoreLog {
  static Future<void> log({String fullname, String authenKey, String activity, String caNumber}) async {
    var now = DateTime.now();
    var formatter = DateFormat('dd-MM-yyy HH:mm:ss');
    String formattedDate = formatter.format(now);

    FirebaseFirestore.instance
        .collection(AppData.cloudFilestoreLogCollection)
        .doc("$formattedDate : $fullname")
        .set({
          "fullname": fullname,
          "authenKey": authenKey,
          "dateTime": formattedDate,
          "activity": activity,
          "caNumber": caNumber,
        })
        .then((_) {})
        .catchError((e) {
          print(e.toString());
        });
  }
}
