import 'package:cloud_firestore/cloud_firestore.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/utils/firestore_log.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

class ClearCountNotificationUtil {
  static Future<void> news() async {
    try {
      FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentNews).get().then((DocumentSnapshot value) async {
        FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentNews).set({
          "running_number": value.get("running_number"),
          "timestamp": AppUtil.timestamp().toString(),
        }).then((_) async {
          int runningFirebase = value.get("running_number");

          await ShareDataUtil.setNewsNotiCount(runningFirebase);
        }).catchError((e) {});
      }).catchError((e) {
        print(e.toString());
      });
    } catch (e) {
      print(e.toString());
      await FirestoreLog.log(
        fullname: ShareDataUtil.getFullname(),
        authenKey: ShareDataUtil.getAuthenKey(),
        activity: "Error Firehase news :: ${e.toString()}",
      );
    }
  }

  static Future<void> activity() async {
    try {
      FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentActivity).get().then((DocumentSnapshot value) async {
        FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentActivity).set({
          "running_number": value.get("running_number"),
          "timestamp": AppUtil.timestamp().toString(),
        }).then((_) async {
          int runningFirebase = value.get("running_number");

          await ShareDataUtil.setActivityNotiCount(runningFirebase);
        }).catchError((e) {
          print(e.toString());
        });
      }).catchError((e) {
        print(e.toString());
      });
    } catch (e) {
      print(e.toString());
      await FirestoreLog.log(
        fullname: ShareDataUtil.getFullname(),
        authenKey: ShareDataUtil.getAuthenKey(),
        activity: "Error Firehase activity :: ${e.toString()}",
        caNumber: ShareDataUtil.getCaNumber(),
      );
    }
  }

  static Future<void> timeline() async {
    try {
      FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentTimeline).get().then((DocumentSnapshot value) async {
        FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentTimeline).set({
          "running_number": value.get("running_number"),
          "timestamp": AppUtil.timestamp().toString(),
        }).then((_) async {
          int runningFirebase = value.get("running_number");

          await ShareDataUtil.setTimelineNotiCount(runningFirebase);
        }).catchError((e) {
          print(e.toString());
        });
      }).catchError((e) {
        print(e.toString());
      });
    } catch (e) {
      print(e.toString());
      await FirestoreLog.log(
        fullname: ShareDataUtil.getFullname(),
        authenKey: ShareDataUtil.getAuthenKey(),
        activity: "Error Firehase timeline :: ${e.toString()}",
        caNumber: ShareDataUtil.getCaNumber(),
      );
    }
  }

  static Future<void> additionalService() async {
    try {
      FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentPackagerequest).get().then((DocumentSnapshot value) async {
        FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentPackagerequest).set({
          "running_number": value.get("running_number"),
          "timestamp": AppUtil.timestamp().toString(),
        }).then((_) async {
          int runningFirebase = value.get("running_number");

          await ShareDataUtil.setAdditionalServiceNotiCount(runningFirebase);
        }).catchError((e) {
          print(e.toString());
        });
      }).catchError((e) {
        print(e.toString());
      });
    } catch (e) {
      print(e.toString());
      await FirestoreLog.log(
        fullname: ShareDataUtil.getFullname(),
        authenKey: ShareDataUtil.getAuthenKey(),
        activity: "Error Firehase additionalService :: ${e.toString()}",
        caNumber: ShareDataUtil.getCaNumber(),
      );
    }
  }

  static Future<void> reportIncident() async {
    try {
      FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentElectricproblem).get().then((DocumentSnapshot value) async {
        FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc(AppData.cloudFilestoreDocumentElectricproblem).set({
          "running_number": value.get("running_number"),
          "timestamp": AppUtil.timestamp().toString(),
        }).then((_) async {
          int runningFirebase = value.get("running_number");

          await ShareDataUtil.setReportIncidentNotiCount(runningFirebase);
        }).catchError((e) {
          print(e.toString());
        });
      }).catchError((e) {
        print(e.toString());
      });
    } catch (e) {
      print(e.toString());
      await FirestoreLog.log(
        fullname: ShareDataUtil.getFullname(),
        authenKey: ShareDataUtil.getAuthenKey(),
        activity: "Error Firehase reportIncident :: ${e.toString()}",
        caNumber: ShareDataUtil.getCaNumber(),
      );
    }
  }

  static Future<void> chat(String masterId) async {
    try {
      if (!AppUtil.isNil(masterId)) {
        FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc("chat-masterid-$masterId").get().then((DocumentSnapshot value) async {
          FirebaseFirestore.instance.collection(AppData.cloudFilestoreCollection).doc("chat-masterid-$masterId").set({
            "running_number": value.get("running_number"),
            "timestamp": AppUtil.timestamp().toString(),
          }).then((_) async {
            int runningFirebase = value.get("running_number");

            await ShareDataUtil.setChatNotiCount(masterId, runningFirebase);
          }).catchError((e) {
            print(e.toString());
          });
        }).catchError((e) {
          print(e.toString());
        });
      }
    } catch (e) {
      print(e.toString());
      await FirestoreLog.log(
        fullname: ShareDataUtil.getFullname(),
        authenKey: ShareDataUtil.getAuthenKey(),
        activity: "Error Firehase chat :: ${e.toString()}",
        caNumber: ShareDataUtil.getCaNumber(),
      );
    }
  }
}
