import 'dart:io';

import 'package:ext_storage/ext_storage.dart';
import 'package:flutter/material.dart';
import 'package:path_provider/path_provider.dart';

class AppUtil {
  static bool isNil(dynamic str) {
    if (str == null) return true;

    if (str is String && (str.isEmpty || str == "")) return true;

    return false;
  }

  static bool isEmail(String em) {
    String p = r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$';

    RegExp regExp = new RegExp(p);

    return regExp.hasMatch(em);
  }

  static bool isPassport(String em) {
    String p = r'^((?!^0+$)[a-zA-Z0-9]{6,9})$';

    RegExp regExp = new RegExp(p);

    return regExp.hasMatch(em);
  }

  static bool isIDCard(String val) {
    if (val.length == 13) {
      //int.parse(val[12])
      int sum = (int.parse(val[0]) * 13) + (int.parse(val[1]) * 12) + (int.parse(val[2]) * 11) + (int.parse(val[3]) * 10) + (int.parse(val[4]) * 9) + (int.parse(val[5]) * 8) + (int.parse(val[6]) * 7) + (int.parse(val[7]) * 6) + (int.parse(val[8]) * 5) + (int.parse(val[9]) * 4) + (int.parse(val[10]) * 3) + (int.parse(val[11]) * 2);

      int modSum = sum % 11;
      int minus = 11 - modSum;

      bool checkSum = int.parse(val[12]) == int.parse(minus.toString()[minus.toString().length - 1]);

      return checkSum;
    }

    return false;
  }

  static bool isPhoneNumber(String val) {
    if (val.length == 10) {
      return int.parse(val[0]) == 0;
    }

    return false;
  }

  static double toNumeric(String val) {
    return double.parse(val.replaceAll(',', ''));
  }

  static int timestamp() {
    return DateTime.now().millisecondsSinceEpoch;
  }

  static double bodyLayoutTopDefault(BuildContext context) {
    bool isPortrait = MediaQuery.of(context).orientation == Orientation.portrait;
    return !isPortrait ? 175 : 205;
  }

  static Future<String> getLocalPath() async {
    if (Platform.isIOS) {
      final directory = await getApplicationDocumentsDirectory();
      return directory.path;
    } else {
      return await ExtStorage.getExternalStoragePublicDirectory(ExtStorage.DIRECTORY_DOWNLOADS);
    }
  }
}
