import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/models/timeline_model.dart';

abstract class TimelineService {
  Future<ResultData> getList({String authenKey, String customerId});
}

class TimelineImpService implements TimelineService {
  @override
  Future<ResultData> getList({@required String authenKey, String customerId}) async {
    List<TimelineModel> resultList = List<TimelineModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.timelineList;
    Map<String, String> body = {
      "customerId": customerId,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          TimelineModel result = TimelineModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
