import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/questionnaire_answer_model.dart';
import 'package:peasmartcare/models/questionnaire_model.dart';
import 'package:peasmartcare/models/questionnaire_question_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class QuestionnaireService {
  Future<ResultData> getList({String authenKey});
  Future<ResultData> getQuestion({String authenKey, String questionnaireId});
  Future<ResultData> sendAnswer({List<QuestionnaireAnswerModel> answerList});
}

class QuestionnaireImpService implements QuestionnaireService {
  @override
  Future<ResultData> getList({@required String authenKey}) async {
    List<QuestionnaireModel> resultList = List<QuestionnaireModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.questionnaireList;
    Map<String, String> body = {
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          QuestionnaireModel result = QuestionnaireModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getQuestion({@required String authenKey, String questionnaireId}) async {
    List<QuestionnaireQuestionModel> resultList = List<QuestionnaireQuestionModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.questionnaireQuestion;
    Map<String, String> body = {
      "RQ_Id": questionnaireId,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data["QuestionDetail"].map((item) {
          QuestionnaireQuestionModel result = QuestionnaireQuestionModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> sendAnswer({List<QuestionnaireAnswerModel> answerList}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.questionnaireSendAnswer;

    List<Map<String, dynamic>> body = answerList.map((item) => item.toJson()).toList();

    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);

      if (response.statusCode == 200) {
        resultData.result = true;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
