import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/profile_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class ProfileService {
  Future<ResultData> getDetail({String authenKey, String idCard});
  Future<ResultData> save({
    String authenKey,
    String firstname,
    String lastname,
    String position,
    String phone,
    String idCard,
    String otherContact,
  });
}

class ProfileImpService implements ProfileService {
  @override
  Future<ResultData> getDetail({@required String authenKey, String idCard}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.profileDetail;

    Map<String, String> body = {
      "citizenNumber": idCard,
      "authenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        ProfileModel result = ProfileModel.fromJson(response.data);

        resultData.result = result;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> save({
    @required String authenKey,
    String firstname,
    String lastname,
    String position,
    String phone,
    String idCard,
    String otherContact,
  }) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.profileSave;

    Map<String, String> body = {
      "position": position,
      "Phone": phone,
      "citizenNumber": idCard,
      "ChannelContact": otherContact,
      "authenKey": authenKey,
    };

    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);

      if (response.statusCode == 200) {
        if (response.data["statusflag"]) {
          resultData.result = true;
        } else {
          resultData.result = false;
        }
      } else {
        resultData.result = false;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
