import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/electricity_statistic_model.dart';
import 'package:peasmartcare/models/electricity_statistic_pea_number_model.dart';
import 'package:peasmartcare/models/electricity_statistic_type_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class ElectricityStatisticService {
  Future<ResultData> getStatisticList({
    String peaNumber,
    String statisticType,
    String caNumber,
    String startDate,
    String endDate,
    String authenKey,
  });
  Future<ResultData> getStatisticTypeList({String authenKey});
  Future<ResultData> getStatisticPeaNumberList({String authenKey, String caNumber});
}

class ElectricityStatisticImpService implements ElectricityStatisticService {
  @override
  Future<ResultData> getStatisticList({
    String peaNumber,
    String statisticType,
    String caNumber,
    String startDate,
    String endDate,
    @required String authenKey,
  }) async {
    List<ElectricityStatisticModel> resultList = List<ElectricityStatisticModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.electricityStatisticList;
    Map<String, String> body = {
      'PeaNo': peaNumber,
      'statisticCode': statisticType,
      'ca': caNumber,
      'startDate': startDate,
      'endDate': endDate,
      "authenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data['StatisticValues'].map((item) {
          ElectricityStatisticModel result = ElectricityStatisticModel.fromJson(item);
          resultList.add(result);
        }).toList();
        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getStatisticTypeList({@required String authenKey}) async {
    List<ElectricityStatisticTypeModel> resultList = List<ElectricityStatisticTypeModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.electricityStatisticTypeList;

    Map<String, String> body = {
      "authenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ElectricityStatisticTypeModel result = ElectricityStatisticTypeModel.fromJson(item);
          resultList.add(result);
        }).toList();
        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getStatisticPeaNumberList({@required String authenKey, String caNumber}) async {
    List<ElectricityStatisticPeaNumberModel> resultList = List<ElectricityStatisticPeaNumberModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.electricityStatisticPeaNumberList;

    Map<String, String> body = {
      'ca': caNumber,
      "authenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ElectricityStatisticPeaNumberModel result = ElectricityStatisticPeaNumberModel.fromJson(item);
          resultList.add(result);
        }).toList();
        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
