import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/otp_model.dart';
import 'package:peasmartcare/models/register_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/models/user_model.dart';

abstract class AuthenService {
  Future<ResultData> login({String fullname, String idCard});
  Future<ResultData> logout({
    String firstname,
    String lastname,
    String phone,
    String idCard,
    String authenKey,
  });
  Future<ResultData> register({
    String firstname,
    String lastname,
    String idCard,
    String phone,
    int cardTypeId,
    String deviceId,
    String imei,
    String osName,
    String osVersion,
    String firebaseToken,
    String deviceModel,
  });
  Future<ResultData> sendOTP(
      {String phoneNumber, String message, String authenKey});
  Future<ResultData> verifyOTP({String otpId, String otp, String authenKey});
  Future<ResultData> visitCount({String authenKey});
}

class AuthenImpService implements AuthenService {
  @override
  Future<ResultData> login({String fullname, String idCard}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.login;

    Map<String, String> body = {
      'UserName': fullname,
      'IDCard': idCard,
    };
    print("loginBody ${body}");

    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);
      print("responseUri ${response.realUri}");
      print("responseUrl ${url}");
      print("responseStatuscode ${response.statusCode}");
      print("responseMSG ${response.statusMessage}");

      if (response.statusCode == 200) {
        UserModel data = UserModel.fromJson(response.data);
        resultData.result = data;
      }
      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
      print("statusCode200 ${response.realUri}");
      print("statusCode200 ${url}");
      print("statusCode200 ${response.statusCode}");
      print("statusCode200 ${response.statusMessage}");
    } on DioError catch (e) {
      print("catch responseUrl ${url}");
      print("catch responseStatuscode ${e}");
      print("catch responseMSG ${e.response.data}");

      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }
    return resultData;
  }

  @override
  Future<ResultData> logout(
      {String firstname,
      String lastname,
      String phone,
      String idCard,
      @required String authenKey}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.logout;

    Map<String, String> body = {
      'contactName': firstname,
      'contactSurName': lastname,
      'contactTel': phone,
      'citizenNumber': idCard,
      'authenKey': authenKey,
    };

    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);
      if (response.statusCode == 200) {
        resultData.result = true;
      } else {
        resultData.result = false;
      }
      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }
    return resultData;
  }

  @override
  Future<ResultData> register({
    String firstname,
    String lastname,
    String idCard,
    String phone,
    int cardTypeId,
    String deviceId,
    String imei,
    String osName,
    String osVersion,
    String firebaseToken,
    String deviceModel,
  }) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.register;

    Map<String, String> body = {
      "DeviceID": deviceId,
      "FirstName": firstname,
      "LastName": lastname,
      "DocType": cardTypeId.toString(),
      "IDCard": idCard,
      "Mobile": phone,
      "RegisterDate": DateTime.now().toString(),
      "IMEINo": imei,
      "OSName": osName,
      "VersionNo": osVersion,
      "RegisterId": firebaseToken,
      "Model": deviceModel,
    };
    print("url ${url}");
    print("body ${body}");
    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);

      if (response.statusCode == 200) {
        resultData.result = RegisterModel.fromJson(response.data);
        print("resultData.result ${resultData.result}");
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      print("resultData.result/ ${resultData.result}");

      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> sendOTP(
      {String phoneNumber, String message, @required String authenKey}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.sendOTP;

    Map<String, String> body = {
      'Mobile': phoneNumber,
      'OTPMessage': message,
      'AuthenKey': authenKey,
    };
    print("aaaa");
    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);
      print("checkurl = ${url}");
      print("checkbody = ${body}");
      print("resp = ${response.statusMessage}");
      print("resp = ${response.data}");

      if (response.statusCode == 200) {
        resultData.result = OtpModel.fromJson(response.data);
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      print("check catch ${e}");

      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> verifyOTP(
      {String otpId, String otp, @required String authenKey}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();
    Response response;

    String url = APIPath.verifyOTP;

    Map<String, String> body = {
      'OTPid': otpId,
      'OTP': otp,
      'AuthenKey': authenKey,
    };
    print("url = {$url}");
    print("OTP Body = {$body}");

    response = await dio.post(Uri.encodeFull(url), data: body);

    print("response.data ${response.data}");
    print("response.statusCode ${response.statusCode}");
    print("response.statusMessage ${response.statusMessage}");

    if (response.statusCode == 200) {
      resultData.result = response.data;
      print("verifyOTP.result ${resultData.result}");
    }

    resultData.statusCode = response.statusCode;
    resultData.statusMessage = response.statusMessage;

    return resultData;
  }

  @override
  Future<ResultData> visitCount({@required String authenKey}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();
    Response response;

    String url = APIPath.visitCount;

    Map<String, String> body = {
      'authenKey': authenKey,
    };
    print("body visitCount = ${body}");
    try {
      response = await dio.get(Uri.encodeFull(url), queryParameters: body);
      print("url visitCount = ${url}");

      if (response.statusCode == 200) {
        resultData.result = true;
      } else {
        resultData.result = false;
      }
      print("response visitCount = ${resultData.statusMessage}");
      print("response visitCount = ${resultData.statusCode}");

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } catch (e) {
      print("Catch visitCount = ${response.statusCode}");
      print("Catch visitCount = ${response.statusMessage}");

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    }
    return resultData;
  }
}
