import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/survey_list/survey_list_bloc.dart';
import 'package:peasmartcare/blocs/survey_question/survey_question_bloc.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';
import 'package:webview_flutter/webview_flutter.dart';
import 'package:webview_flutter_plus/webview_flutter_plus.dart';

class SurveyQuestion extends StatefulWidget {
  final String surveyId;
  final String surveyName;
  final String customerId;
  final String fullname;

  const SurveyQuestion({
    Key key,
    @required this.surveyId,
    @required this.surveyName,
    @required this.customerId,
    @required this.fullname,
  }) : super(key: key);

  @override
  _SurveyQuestionState createState() => _SurveyQuestionState();
}

class _SurveyQuestionState extends State<SurveyQuestion> {
  WebViewPlusController _webViewController;
  String urlPath;
  String urlSuccessPath;
  String urlUnsuccessPath;

  // double _webViewHeight = 0;
  final _formKey = GlobalKey<FormState>();
  int _currentIndex = 0;

  @override
  void initState() {
    context.read<SurveyQuestionBloc>().add(SurveyQuestionGetList());
    urlPath = "${APIPath.surveyQuestionWebView}?id=${widget.surveyId}&customerId=${widget.customerId}&username=${widget.fullname}&AuthenKey=${ShareDataUtil.getAuthenKey()}";
    urlSuccessPath = APIPath.surveyQuestionSendSuccessWebView;
    urlUnsuccessPath = APIPath.surveyQuestionSendUnsuccessWebView;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        title: "บันทึกแบบสำรวจข้อมูล",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      body: _buildItem(),
    );
  }

  Widget _buildItem() {
    Size deviceSize = MediaQuery.of(context).size;

    return Container(
      // height: _webViewHeight == 0 ? deviceSize.height : _webViewHeight,
      height: deviceSize.height,
      child: WebViewPlus(
        javascriptMode: JavascriptMode.unrestricted,
        onWebViewCreated: (controller) {
          this._webViewController = controller;
          controller.loadUrl(Uri.encodeFull(urlPath));
        },
        onPageFinished: (url) {
          _webViewController.getHeight().then((double height) {
            // setState(() {
            //   _webViewHeight = height;
            // });
          });

          // print("===== url ========");
          // print(url);

          // print(url.contains('data:text/html;base64,'));
          if (!url.contains(urlPath)) {
            if (url.contains(urlSuccessPath) || url.contains("$urlSuccessPath/")) {
              context.read<SurveyListBloc>().add(SurveyListGetList());
              SweetAlert.show(
                context,
                subtitle: "ส่งแบบสำรวจสำเร็จ",
                style: SweetAlertStyle.success,
                showCancelButton: false,
                onPress: (bool isConfirm) {
                  if (isConfirm) {
                    Navigator.pop(context);
                    Navigator.pop(context);
                    return false;
                  }
                },
              );
            } else if (url.contains(urlUnsuccessPath) || url.contains("$urlUnsuccessPath/")) {
              SweetAlert.show(
                context,
                subtitle: "ส่งแบบสำรวจไม่สำเร็จ",
                style: SweetAlertStyle.error,
                showCancelButton: false,
                onPress: (bool isConfirm) {
                  if (isConfirm) {
                    Navigator.pop(context);
                    Navigator.pop(context);
                    return false;
                  }
                },
              );
            }
          }
        },
      ),
    );
  }
}
