import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/survey_group_list/survey_group_list_bloc.dart';
import 'package:peasmartcare/blocs/survey_list/survey_list_bloc.dart';
import 'package:peasmartcare/models/survey_group_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/survey/survey.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class SurveyGroupList extends StatefulWidget {
  @override
  _SurveyGroupListState createState() => _SurveyGroupListState();
}

class _SurveyGroupListState extends State<SurveyGroupList> {
  @override
  void initState() {
    context.read<SurveyGroupListBloc>().add(SurveyGroupListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<SurveyGroupListBloc, SurveyGroupListState>(
      listener: (context, state) {
        if (state is SurveyGroupListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<SurveyGroupListBloc, SurveyGroupListState>(
        builder: (context, state) {
          if (state is SurveyGroupListLoading) {
            return Loading();
          } else if (state is SurveyGroupListLoaded) {
            List<SurveyGroupModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is SurveyGroupListNotFound) {
            return NotFoundBox();
          } else if (state is SurveyGroupListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(SurveyGroupModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return InkWell(
      child: Container(
        padding: const EdgeInsets.all(5),
        child: Card(
          elevation: 3,
          child: Container(
            padding: EdgeInsets.all(15),
            width: deviceSize.width - 40,
            child: Text("${item.code.trim()}  ${item.code.trim().isNotEmpty ? ':' : ''}  ${item.subject.trim()}"),
            // child: Table(
            //   // columnWidths: {0: FixedColumnWidth(110)},
            //   children: [
            //     TableRow(
            //       children: [
            //         TableCell(
            //           child: Text("${item.code}  ${item.subject}"),
            //         ),
            //         // TableCell(
            //         //   child: Text(item.subject),
            //         // ),
            //       ],
            //     ),
            //   ],
            // ),
          ),
        ),
      ),
      onTap: () {
        context.read<SurveyListBloc>().add(SurveyListAddSurveyId(
              surveyId: item.id,
            ));
        Navigator.push(
          context,
          MaterialPageRoute(builder: (context) => SurveyPage(surveyId: item.id)),
        );
      },
    );
  }
}
