import 'package:flutter/material.dart';
import 'package:peasmartcare/blocs/survey_question/survey_question_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/survey_answer_model.dart';
import 'package:peasmartcare/models/survey_choice_model.dart';

class SurveyChoiceText extends StatefulWidget {
  final List<SurveyChoiceModel> surveyChoiceList;
  final SurveyQuestionBloc bloc;
  final int currentIndex;
  final String surveyId;
  final bool isNext;
  final String customerId;
  final bool isValidate;
  final int maxLength;
  final String defaultVelue;

  const SurveyChoiceText({
    Key key,
    @required this.bloc,
    @required this.surveyChoiceList,
    @required this.currentIndex,
    @required this.surveyId,
    @required this.isNext,
    @required this.customerId,
    this.isValidate = false,
    this.maxLength = 4000,
    this.defaultVelue,
  }) : super(key: key);

  @override
  _SurveyChoiceTextState createState() => _SurveyChoiceTextState();
}

class _SurveyChoiceTextState extends State<SurveyChoiceText> {
  final _formKey = GlobalKey<FormState>();
  SurveyChoiceModel _survey = SurveyChoiceModel();
  TextEditingController _value = TextEditingController();
  TextStyle textStyle = TextStyle(color: Color(AppData.primaryColor), fontSize: 18);
  TextStyle errortyle = TextStyle(color: Colors.red[900], fontSize: 18);

  @override
  void initState() {
    if (widget.surveyChoiceList.length > 0) {
      _survey = widget.surveyChoiceList[0];
    }
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      child: Column(
        children: <Widget>[
          SizedBox(height: 5),
          Form(
            key: _formKey,
            child: Container(
              // height: 85,
              padding: EdgeInsets.only(left: 5, right: 5),
              child: TextFormField(
                validator: (value) {
                  if (widget.isValidate && value.isEmpty) {
                    return "กรุณากรอก ${_survey.name}";
                  } else if (widget.isValidate && value.isNotEmpty && value.length > widget.maxLength) {
                    return "กรุณากรอกไม่เกิน ${widget.maxLength} ตัวอักษร";
                  }
                  return null;
                },
                controller: _value,
                maxLines: 3,
                style: textStyle,
                decoration: InputDecoration(
                  hintText: _survey.name,
                  hintStyle: textStyle,
                  labelText: _survey.name,
                  labelStyle: textStyle,
                  errorStyle: errortyle,
                  floatingLabelBehavior: FloatingLabelBehavior.auto,
                  filled: true,
                  fillColor: Color(AppData.whiteColor),
                  contentPadding: EdgeInsets.symmetric(vertical: 10, horizontal: 15),
                  border: OutlineInputBorder(
                    borderRadius: const BorderRadius.all(
                      const Radius.circular(20),
                    ),
                  ),
                ),
              ),
            ),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                child: RaisedButton(
                  padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(7),
                  ),
                  child: Text(
                    widget.isNext ? "ถัดไป" : "ส่งแบบสำรวจ",
                    style: TextStyle(
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                  color: Color(AppData.yellowColor),
                  onPressed: () {
                    if (_formKey.currentState.validate()) {
                      SurveyAnswerModel answer = SurveyAnswerModel();
                      if (widget.surveyChoiceList.length > 0) {
                        answer.questionId = _survey.questionId;
                        answer.choiceId = _survey.id;
                        answer.value = _value.text;
                        answer.customerId = widget.customerId;

                        widget.bloc.add(SurveyQuestionAddAnswer(
                          answer: answer,
                        ));

                        widget.bloc.add(SurveyQuestionGetCurrentQuestion(
                          currentIndex: widget.currentIndex + 1,
                        ));

                        if (!widget.isNext) {
                          widget.bloc.add(SurveyQuestionSendAnswer());
                        }
                      } else {
                        widget.bloc.add(SurveyQuestionGetCurrentQuestion(
                          currentIndex: widget.currentIndex + 1,
                        ));
                      }
                    }
                  },
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
