import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/select_electricity_location_list/select_electricity_location_list_bloc.dart';
import 'package:peasmartcare/models/electricity_location_customer_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/home/home.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class SelectElectricityLocationList extends StatefulWidget {
  @override
  _SelectElectricityLocationListState createState() => _SelectElectricityLocationListState();
}

class _SelectElectricityLocationListState extends State<SelectElectricityLocationList> {
  @override
  void initState() {
    context.read<SelectElectricityLocationListBloc>().add(SelectElectricityLocationListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<SelectElectricityLocationListBloc, SelectElectricityLocationListState>(
      listener: (context, state) {
        if (state is SelectElectricityLocationListLoaded) {
          if (state.deleteSuccess == null && state.electricityLocationCustomer != null) {
            Navigator.pop(context);
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => HomePage()),
            );
          } else if (state.deleteSuccess != null && state.deleteSuccess) {
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลสำเร็จ",
              style: SweetAlertStyle.success,
            );

            context.read<SelectElectricityLocationListBloc>().add(SelectElectricityLocationListGetList());
          } else if (state.deleteSuccess != null && !state.deleteSuccess) {
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลไม่สำเร็จ",
              style: SweetAlertStyle.error,
            );
          }
        } else if (state is SelectElectricityLocationListError) {
          SweetAlert.show(
            context,
            subtitle: state.message,
            style: SweetAlertStyle.error,
            onPress: (bool isConfirm) {
              Navigator.pop(context);

              context.read<SelectElectricityLocationListBloc>().add(SelectElectricityLocationListGetList());
              return false;
            },
          );
        } else if (state is SelectElectricityLocationListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<SelectElectricityLocationListBloc, SelectElectricityLocationListState>(
        builder: (context, state) {
          if (state is SelectElectricityLocationListLoading) {
            return Loading();
          } else if (state is SelectElectricityLocationListLoaded) {
            List<ElectricityLocationCustomerModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is SelectElectricityLocationListNotFound) {
            return NotFoundBox();
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(ElectricityLocationCustomerModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return InkWell(
      child: Container(
        padding: const EdgeInsets.all(5),
        child: Card(
          elevation: 3,
          child: Container(
            padding: EdgeInsets.all(15),
            width: deviceSize.width - 40,
            child: Row(
              children: [
                Container(
                  width: deviceSize.width - 100,
                  child: Table(
                    columnWidths: {0: FixedColumnWidth(120)},
                    children: [
                      TableRow(
                        children: [
                          TableCell(
                            child: Text(item.caNumber ?? ""),
                          ),
                        ],
                      ),
                      TableRow(
                        children: [
                          TableCell(
                            child: Text(item.customerName ?? ""),
                          ),
                        ],
                      ),
                      TableRow(
                        children: [
                          TableCell(
                            child: Text(item.address ?? ""),
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
                Container(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      InkWell(
                        child: Icon(
                          Icons.delete,
                          color: Colors.red,
                        ),
                        onTap: () {
                          SweetAlert.show(
                            context,
                            title: "ต้องการลบข้อมูลใช่หรือไม่",
                            style: SweetAlertStyle.confirm,
                            showCancelButton: true,
                            onPress: (bool isConfirm) {
                              if (isConfirm) {
                                SweetAlert.show(context, subtitle: "กำลังลบ...", style: SweetAlertStyle.loading);

                                context.read<SelectElectricityLocationListBloc>().add(
                                      SelectElectricityLocationListOnDelete(
                                        customerId: item.customerId,
                                      ),
                                    );
                                Navigator.pop(context);
                                return false;
                              }
                            },
                          );
                        },
                      )
                    ],
                  ),
                )
              ],
            ),
          ),
        ),
      ),
      onTap: () {
        context.read<SelectElectricityLocationListBloc>().add(
              SelectElectricityLocationListOnSelected(electricityLocationCustomer: item),
            );
      },
    );
  }
}
