import 'package:flutter/material.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/select_electricity_location/select_electricity_location_form.dart';

class SelectElectricityLocationAddEdit extends StatefulWidget {
  @override
  _SelectElectricityLocationAddEditState createState() => _SelectElectricityLocationAddEditState();
}

class _SelectElectricityLocationAddEditState extends State<SelectElectricityLocationAddEdit> {
  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ลงทะเบียนสถานที่ใช้ไฟฟ้า",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      body: BodyLayout(
        top: 0,
        layoutType: LayoutType.ONLY_CHILD,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ลงทะเบียนสถานที่ใช้ไฟฟ้า",
                  icon: ImageAsset.contactLocationImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 50),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            SelectElectricityLocationForm(),
          ],
        ),
      ),
    );
  }
}