import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/select_electricity_location_list/select_electricity_location_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/select_electricity_location/select_electricity_location_add_edit.dart';
import 'package:peasmartcare/pages/select_electricity_location/select_electricity_location_list.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class SelectElectricityLocationPage extends StatefulWidget {
  final bool isFromHome;

  const SelectElectricityLocationPage({Key key, this.isFromHome = false})
      : super(key: key);

  @override
  _SelectElectricityLocationPageState createState() =>
      _SelectElectricityLocationPageState();
}

class _SelectElectricityLocationPageState
    extends State<SelectElectricityLocationPage> {
  RefreshController _refreshController =
      RefreshController(initialRefresh: false);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        title: "เลือกสถานที่ใช้ไฟฟ้า",
        leading: widget.isFromHome
            ? IconButton(
                icon: Icon(Icons.arrow_back_ios),
                onPressed: () {
                  Navigator.of(context).popUntil((route) => route.isFirst);
                },
                tooltip: MaterialLocalizations.of(context).openAppDrawerTooltip,
              )
            : EmptyBox(heightFactor: 0),
      ),
      floatingActionButton: FloatingActionButton(
        onPressed: () {
          Navigator.push(
            context,
            MaterialPageRoute(
                builder: (context) => SelectElectricityLocationAddEdit()),
          );
        },
        tooltip: "เพิ่มสถานที่ใช้ไฟ",
        child: Icon(Icons.add, color: Color(AppData.whiteColor)),
        backgroundColor: Color(AppData.yellowColor),
      ),
      body: BodyLayout(
        top: 0,
        layoutType: LayoutType.ONLY_CHILD,
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "เลือกสถานที่ใช้ไฟฟ้า",
                  icon: ImageAsset.contactLocationImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            SelectElectricityLocationList(),
          ],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context
        .read<SelectElectricityLocationListBloc>()
        .add(SelectElectricityLocationListGetList());

    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
