import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/report_incident_plan_list/report_incident_plan_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_menu.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_plan_list.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class ReportIncidentPlanPage extends StatefulWidget {
  @override
  _ReportIncidentPlanPageState createState() => _ReportIncidentPlanPageState();
}

class _ReportIncidentPlanPageState extends State<ReportIncidentPlanPage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);
  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ดูแผนดับไฟฟ้า",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(),
      body: BodyLayout(
        header: CustomerInfo(),
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ดูแผนดับไฟฟ้า",
                  icon: ImageAsset.reportIncidentImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            ReportIncidentMenu(activeIndex: 2),
            ReportIncidentPlanList(),
          ],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<ReportIncidentPlanListBloc>().add(ReportIncidentPlanListGetList());
    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
