import 'package:flutter/material.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/report_incident/report_incident.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_history.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_plan.dart';

class ReportIncidentMenu extends StatefulWidget {
  final activeIndex;

  const ReportIncidentMenu({Key key, this.activeIndex = 0}) : super(key: key);

  @override
  _ReportIncidentMenuState createState() => _ReportIncidentMenuState();
}

class _ReportIncidentMenuState extends State<ReportIncidentMenu> {
  // int _activeIndex;
  @override
  void initState() {
    // _activeIndex = widget.activeIndex;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Container(
        constraints: BoxConstraints(minWidth: 300, maxWidth: 500),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceAround,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            InkWell(
              child: Card(
                elevation: 3,
                color: widget.activeIndex == 0 ? Color(AppData.primaryColor) : Color(AppData.whiteColor),
                child: Container(
                  width: 100,
                  height: 100,
                  padding: EdgeInsets.fromLTRB(5, 10, 5, 5),
                  child: Column(
                    children: <Widget>[
                      Text(
                        "แจ้งเหตุ\nไฟฟ้าขัดข้อง",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: widget.activeIndex == 0 ? Color(AppData.whiteColor) : Color(AppData.greyColor),
                        ),
                      ),
                      SizedBox(height: 8),
                      Image.asset(
                        ImageAsset.reportIncidentSubMenuImg,
                        height: 25,
                        width: 25,
                        fit: BoxFit.fill,
                      ),
                    ],
                  ),
                ),
              ),
              onTap: () {
                if (widget.activeIndex != 0) {
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(builder: (context) => ReportIncidentPage()),
                  );
                }
              },
            ),
            InkWell(
              child: Card(
                elevation: 3,
                color: widget.activeIndex == 1 ? Color(AppData.primaryColor) : Color(AppData.whiteColor),
                child: Container(
                  width: 100,
                  height: 100,
                  padding: EdgeInsets.fromLTRB(5, 10, 5, 5),
                  child: Column(
                    children: <Widget>[
                      Text(
                        "ประวัติ\nไฟฟ้าขัดข้อง",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: widget.activeIndex == 1 ? Color(AppData.whiteColor) : Color(AppData.greyColor),
                        ),
                      ),
                      SizedBox(height: 8),
                      Image.asset(
                        ImageAsset.reportIncidentHistorySubMenuImg,
                        height: 25,
                        width: 25,
                        fit: BoxFit.fill,
                      ),
                    ],
                  ),
                ),
              ),
              onTap: () {
                if (widget.activeIndex != 1) {
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(builder: (context) => ReportIncidentHistoryPage()),
                  );
                }
              },
            ),
            InkWell(
              child: Card(
                color: widget.activeIndex == 2 ? Color(AppData.primaryColor) : Color(AppData.whiteColor),
                elevation: 3,
                child: Container(
                  width: 100,
                  height: 100,
                  padding: EdgeInsets.fromLTRB(5, 10, 5, 5),
                  child: Column(
                    children: <Widget>[
                      Text(
                        "ดูแผนดับไฟฟ้า",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: widget.activeIndex == 2 ? Color(AppData.whiteColor) : Color(AppData.greyColor),
                        ),
                      ),
                      SizedBox(height: 30),
                      Image.asset(
                        ImageAsset.reportIncidentPlanSubMenuImg,
                        height: 25,
                        width: 25,
                        fit: BoxFit.fill,
                      ),
                    ],
                  ),
                ),
              ),
              onTap: () {
                if (widget.activeIndex != 2) {
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(builder: (context) => ReportIncidentPlanPage()),
                  );
                }
              },
            ),
          ],
        ),
      ),
    );
  }
}
