import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/report_incident_history_list/report_incident_history_list_bloc.dart';
import 'package:peasmartcare/models/report_incident_history_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class ReportIncidentHistoryList extends StatefulWidget {
  @override
  _ReportIncidentHistoryListState createState() => _ReportIncidentHistoryListState();
}

class _ReportIncidentHistoryListState extends State<ReportIncidentHistoryList> {
  @override
  void initState() {
    context.read<ReportIncidentHistoryListBloc>().add(ReportIncidentHistoryListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<ReportIncidentHistoryListBloc, ReportIncidentHistoryListState>(
      listener: (context, state) {
        if (state is ReportIncidentHistoryListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<ReportIncidentHistoryListBloc, ReportIncidentHistoryListState>(
        builder: (context, state) {
          if (state is ReportIncidentHistoryListLoading) {
            return Loading();
          } else if (state is ReportIncidentHistoryListLoaded) {
            List<ReportIncidentHistoryModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is ReportIncidentHistoryListNotFound) {
            return NotFoundBox();
          } else if (state is ReportIncidentHistoryListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(ReportIncidentHistoryModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {0: FixedColumnWidth(80)},
            children: [
              TableRow(
                children: [
                  TableCell(
                    child: Text("วันที่"),
                  ),
                  TableCell(
                    child: Text("${item.startDate} ถึง ${AppUtil.isNil(item.endDate) ? "-" : item.endDate}"),
                  ),
                ],
              ),
              // TableRow(
              //   children: [
              //     TableCell(
              //       child: Text("ถึงวันที่"),
              //     ),
              //     TableCell(
              //       child: Text(item.endDate),
              //     ),
              //   ],
              // ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("รายละเอียด"),
                  ),
                  TableCell(
                    child: Text(item.detail),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("ประเภท"),
                  ),
                  TableCell(
                    child: Text(item.detailType),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("ผู้แจ้ง"),
                  ),
                  TableCell(
                    child: Text(item.informant),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
