import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_slidable/flutter_slidable.dart';
import 'package:peasmartcare/blocs/questionnaire_list/questionnaire_list_bloc.dart';
import 'package:peasmartcare/blocs/questionnaire_question/questionnaire_question_bloc.dart';
import 'package:peasmartcare/models/questionnaire_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/questionnaire/questionnaire_question.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class QuestionnaireList extends StatefulWidget {
  @override
  _QuestionnaireListState createState() => _QuestionnaireListState();
}

class _QuestionnaireListState extends State<QuestionnaireList> {
  @override
  void initState() {
    context.read<QuestionnaireListBloc>().add(QuestionnaireListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<QuestionnaireListBloc, QuestionnaireListState>(
      listener: (context, state) {
        if (state is QuestionnaireListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<QuestionnaireListBloc, QuestionnaireListState>(
        builder: (context, state) {
          if (state is QuestionnaireListLoading) {
            return Loading();
          } else if (state is QuestionnaireListLoaded) {
            List<QuestionnaireModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return Slidable(
                  actionPane: SlidableBehindActionPane(),
                  actionExtentRatio: 0.25,
                  child: _buildTable(item),
                );
              }).toList(),
            );
          } else if (state is QuestionnaireListNotFound) {
            return NotFoundBox();
          } else if (state is QuestionnaireListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(QuestionnaireModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return InkWell(
      child: Container(
        padding: const EdgeInsets.all(5),
        child: Card(
          elevation: 3,
          child: Container(
            padding: EdgeInsets.all(15),
            width: deviceSize.width - 40,
            child: Table(
              columnWidths: {0: FixedColumnWidth(100)},
              children: [
                TableRow(
                  children: [
                    TableCell(
                      child: Text("เรื่อง"),
                    ),
                    TableCell(
                      child: Text(item.subject),
                    ),
                  ],
                ),
                TableRow(
                  children: [
                    TableCell(
                      child: Text("รายละเอียด"),
                    ),
                    TableCell(
                      child: Text(item.description),
                    ),
                  ],
                ),
                TableRow(
                  children: [
                    TableCell(
                      child: Text("วันเวลาที่เริ่ม"),
                    ),
                    TableCell(
                      child: Text(item.startDate),
                    ),
                  ],
                ),
                TableRow(
                  children: [
                    TableCell(
                      child: Text("วันเวลาที่สิ้นสุด"),
                    ),
                    TableCell(
                      child: Text(item.endDate),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      ),
      onTap: () {
        context.read<QuestionnaireQuestionBloc>().add(QuestionnaireQuestionAddQuestionnaireId(
              questionnaireId: item.id,
            ));
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (context) => QuestionnaireQuestion(
              questionnaireId: item.id,
              questionnaireName: item.subject,
              customerId: ShareDataUtil.getCustomerId(),
              fullname: ShareDataUtil.getFullname(),
            ),
          ),
        );
      },
    );
  }
}
