import 'package:flutter/material.dart';
import 'package:peasmartcare/blocs/questionnaire_question/questionnaire_question_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/questionnaire_answer_model.dart';
import 'package:peasmartcare/models/questionnaire_choice_model.dart';

class QuestionnaireChoiceText extends StatefulWidget {
  final List<QuestionnaireChoiceModel> questionnaireChoiceList;
  final QuestionnaireQuestionBloc bloc;
  final int currentIndex;
  final String questionnaireId;
  final bool isNext;
  final String customerId;

  const QuestionnaireChoiceText({
    Key key,
    @required this.questionnaireChoiceList,
    @required this.bloc,
    @required this.currentIndex,
    @required this.questionnaireId,
    @required this.isNext,
    @required this.customerId,
  }) : super(key: key);

  @override
  _QuestionnaireChoiceTextState createState() => _QuestionnaireChoiceTextState();
}

class _QuestionnaireChoiceTextState extends State<QuestionnaireChoiceText> {
  final _formKey = GlobalKey<FormState>();
  TextEditingController _value = TextEditingController();
  TextStyle textStyle = TextStyle(color: Color(AppData.primaryColor), fontSize: 18);
  TextStyle errortyle = TextStyle(color: Colors.red[900], fontSize: 18);

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      // height: 430,
      width: double.infinity,
      child: Column(
        children: <Widget>[
          SizedBox(height: 30),
          Form(
            key: _formKey,
            child: Container(
              // height: 85,
              padding: EdgeInsets.only(left: 5, right: 5),
              child: TextFormField(
                validator: (value) {
                  if (value.isEmpty) {
                    return "กรุณากรอกคำตอบ";
                  }
                  return null;
                },
                controller: _value,
                maxLines: 8,
                style: textStyle,
                decoration: InputDecoration(
                  hintText: "คำตอบ",
                  hintStyle: textStyle,
                  labelText: "คำตอบ",
                  labelStyle: textStyle,
                  errorStyle: errortyle,
                  floatingLabelBehavior: FloatingLabelBehavior.auto,
                  filled: true,
                  fillColor: Color(AppData.whiteColor),
                  contentPadding: EdgeInsets.symmetric(vertical: 10, horizontal: 15),
                  border: OutlineInputBorder(
                    borderRadius: const BorderRadius.all(
                      const Radius.circular(20),
                    ),
                  ),
                ),
              ),
            ),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                child: RaisedButton(
                  padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(7),
                  ),
                  child: Text(
                    widget.isNext ? "ถัดไป" : "ส่งแบบสอบถาม",
                    style: TextStyle(
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                  color: Color(AppData.yellowColor),
                  onPressed: () {
                    if (_formKey.currentState.validate()) {
                      QuestionnaireAnswerModel answer = QuestionnaireAnswerModel();
                      if (widget.questionnaireChoiceList.length > 0) {
                        answer.questionId = widget.questionnaireChoiceList[0].questionId;
                        answer.choiceId = widget.questionnaireChoiceList[0].id;
                        answer.value = _value.text;
                        answer.customerId = widget.customerId;

                        widget.bloc.add(QuestionnaireQuestionAddAnswer(
                          answer: answer,
                        ));

                        widget.bloc.add(QuestionnaireQuestionGetCurrentQuestion(
                          currentIndex: widget.currentIndex + 1,
                        ));

                        if (!widget.isNext) {
                          widget.bloc.add(QuestionnaireQuestionSendAnswer());
                        }
                      }
                    }
                  },
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
