import 'package:flutter/material.dart';
import 'package:grouped_buttons/grouped_buttons.dart';
import 'package:peasmartcare/blocs/questionnaire_question/questionnaire_question_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/questionnaire_answer_model.dart';
import 'package:peasmartcare/models/questionnaire_choice_model.dart';

class QuestionnaireChoiceCheckbox extends StatefulWidget {
  final List<QuestionnaireChoiceModel> questionnaireChoiceList;
  final QuestionnaireQuestionBloc bloc;
  final int currentIndex;
  final String questionnaireId;
  final bool isNext;
  final String customerId;

  const QuestionnaireChoiceCheckbox({
    Key key,
    @required this.questionnaireChoiceList,
    @required this.bloc,
    @required this.currentIndex,
    @required this.questionnaireId,
    @required this.isNext,
    @required this.customerId,
  }) : super(key: key);

  @override
  _QuestionnaireChoiceCheckboxState createState() => _QuestionnaireChoiceCheckboxState();
}

class _QuestionnaireChoiceCheckboxState extends State<QuestionnaireChoiceCheckbox> {
  List<String> _checkedShow = [];
  List<QuestionnaireChoiceModel> _checkedResult = List<QuestionnaireChoiceModel>();
  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      child: Column(
        children: <Widget>[
          Card(
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(20),
            ),
            color: Colors.purple[50],
            child: CheckboxGroup(
              orientation: GroupedButtonsOrientation.VERTICAL,
              activeColor: Color(AppData.yellowColor),
              labelStyle: TextStyle(color: Color(AppData.purpleColor)),
              margin: const EdgeInsets.only(left: 12.0),
              onSelected: (List selected) => setState(() {
                QuestionnaireChoiceModel qtObj;
                _checkedResult = List<QuestionnaireChoiceModel>();
                _checkedShow = selected;
                _checkedShow.map((item) => {qtObj = widget.questionnaireChoiceList.singleWhere((qt) => item == qt.name, orElse: () => null), _checkedResult.add(qtObj)}).toList();
              }),
              labels: widget.questionnaireChoiceList.map((item) {
                return item.name;
              }).toList(),
              checked: _checkedShow,
              itemBuilder: (Checkbox cb, Text txt, int i) {
                return Row(
                  children: <Widget>[
                    cb,
                    txt,
                  ],
                );
              },
            ),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                child: RaisedButton(
                  padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(7),
                  ),
                  child: Text(
                    widget.isNext ? "ถัดไป" : "ส่งแบบสอบถาม",
                    style: TextStyle(
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                  color: Color(AppData.yellowColor),
                  onPressed: () {
                    _checkedResult.map((item) {
                      QuestionnaireAnswerModel answer = QuestionnaireAnswerModel();
                      answer.questionId = item.questionId;
                      answer.choiceId = item.id;
                      answer.value = item.id;
                      answer.customerId = widget.customerId;

                      widget.bloc.add(QuestionnaireQuestionAddAnswer(
                        answer: answer,
                      ));
                      widget.bloc.add(QuestionnaireQuestionGetCurrentQuestion(
                        currentIndex: widget.currentIndex + 1,
                      ));
                    }).toList();

                    if (!widget.isNext && _checkedResult.length > 0) {
                      widget.bloc.add(QuestionnaireQuestionSendAnswer());
                    }
                  },
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
