import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/news_list/news_list_bloc.dart';
import 'package:peasmartcare/models/news_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/news/news_detail.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/image_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class NewsList extends StatefulWidget {
  @override
  _NewsListState createState() => _NewsListState();
}

class _NewsListState extends State<NewsList> {
  @override
  void initState() {
    context.read<NewsListBloc>().add(NewsListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<NewsListBloc, NewsListState>(
      listener: (context, state) {
        if (state is NewsListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<NewsListBloc, NewsListState>(
        builder: (context, state) {
          if (state is NewsListLoading) {
            return Loading();
          } else if (state is NewsListLoaded) {
            List<NewsModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return item.isActive ? _buildList(item) : EmptyBox(heightFactor: 0);
              }).toList(),
            );
          } else if (state is NewsListNotFound) {
            return NotFoundBox();
          } else if (state is NewsListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildList(NewsModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return InkWell(
      child: Container(
        padding: const EdgeInsets.all(5),
        child: Card(
          elevation: 3,
          child: Row(
            children: <Widget>[
              ImageBox(
                height: 120,
                width: 120,
                src: item.image,
                borderRadius: BorderRadius.only(topLeft: Radius.circular(3), bottomLeft: Radius.circular(3)),
              ),
              Container(
                padding: EdgeInsets.all(15),
                height: 120,
                width: deviceSize.width - 170,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceAround,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(item?.subject ?? "", maxLines: 1, overflow: TextOverflow.ellipsis),
                    Text(item?.typeName ?? "", maxLines: 1, overflow: TextOverflow.ellipsis),
                    Text(item?.dateTime ?? ""),
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
      onTap: () {
        Navigator.push(
          context,
          MaterialPageRoute(builder: (context) => NewsDetail(id: item.id)),
        );
      },
    );
  }
}
