import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_swiper/flutter_swiper.dart';
import 'package:peasmartcare/blocs/news_featured_list/news_featured_list_bloc.dart';
import 'package:peasmartcare/models/news_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/news/news_detail.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/image_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class NewsFeaturedList extends StatefulWidget {
  @override
  _NewsFeaturedListState createState() => _NewsFeaturedListState();
}

class _NewsFeaturedListState extends State<NewsFeaturedList> {
  @override
  void initState() {
    context.read<NewsFeaturedListBloc>().add(NewsFeaturedListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<NewsFeaturedListBloc, NewsFeaturedListState>(
      listener: (context, state) {
        if (state is NewsFeaturedListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<NewsFeaturedListBloc, NewsFeaturedListState>(
        builder: (context, state) {
          if (state is NewsFeaturedListLoading) {
            return Loading();
          } else if (state is NewsFeaturedListLoaded) {
            List<NewsModel> resultList = state.result;
            return _buildSlide(resultList);
          } else if (state is NewsFeaturedListNotFound) {
            return NotFoundBox();
          } else if (state is NewsFeaturedListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Column _buildSlide(List<NewsModel> newsList) {
    return Column(
      children: <Widget>[
        Container(
          height: 340,
          padding: EdgeInsets.all(16.0),
          child: Swiper(
            autoplay: true,
            fade: 0.0,
            itemBuilder: (BuildContext context, int index) {
              return InkWell(
                child: Column(
                  children: <Widget>[
                    ImageBox(
                      height: 200,
                      src: newsList[index].image,
                      borderRadius: BorderRadius.only(topLeft: Radius.circular(10), topRight: Radius.circular(10)),
                    ),
                    Container(
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.only(
                          bottomLeft: Radius.circular(10),
                          bottomRight: Radius.circular(10),
                        ),
                      ),
                      child: ListTile(
                        title: AutoSizeText(newsList[index].subject, maxLines: 2),
                      ),
                    )
                  ],
                ),
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => NewsDetail(id: newsList[index].id)),
                  );
                },
              );
            },
            itemCount: newsList.length,
            scale: 0.9,
            pagination: SwiperPagination(),
          ),
        ),
      ],
    );
  }
}
