import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:flutter_custom_clippers/flutter_custom_clippers.dart';
import 'package:fluttericon/typicons_icons.dart';
import 'package:fluttericon/web_symbols_icons.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/models/customer_info_model.dart';
import 'package:peasmartcare/pages/about_us/about_us.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/profile/profile.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class HomeLeftSidebarMenu extends StatefulWidget {
  @override
  _HomeLeftSidebarMenuState createState() => _HomeLeftSidebarMenuState();
}

class _HomeLeftSidebarMenuState extends State<HomeLeftSidebarMenu> with TickerProviderStateMixin {
  TextStyle userInfoStyle = TextStyle(fontSize: 18, color: Color(AppData.whiteColor));
  @override
  Widget build(BuildContext context) {
    return Drawer(
      child: ListView(
        padding: EdgeInsets.zero,
        children: <Widget>[
          ClipPath(
            clipper: WaveClipperTwo(),
            child: Container(
              height: 270,
              color: Color(AppData.purpleColor),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Container(
                    child: CircleAvatar(
                      backgroundColor: Colors.white,
                      radius: 40,
                      child: CircleAvatar(radius: 38, backgroundImage: AssetImage(ImageAsset.imageDefaultAvartar)),
                    ),
                  ),
                  SizedBox(height: 15),
                  AutoSizeText(
                    ShareDataUtil.getFullname(),
                    minFontSize: 8,
                    maxLines: 1,
                    textAlign: TextAlign.center,
                    style: userInfoStyle,
                  ),
                  SizedBox(height: 5),
                  FutureBuilder<dynamic>(
                      future: ShareDataUtil.getCustomerInfo(),
                      builder: (context, snapshot) {
                        if (snapshot.hasData) {
                          CustomerInfoModel user = snapshot.data;
                          return AutoSizeText(
                            user.customerName,
                            minFontSize: 8,
                            maxLines: 1,
                            textAlign: TextAlign.center,
                            style: userInfoStyle,
                          );
                        }
                        return Loading();
                      })
                ],
              ),
            ),
          ),
          SizedBox(height: 10),
          MenuAction(
            name: "ข้อมูลส่วนตัว",
            color: Color(AppData.purpleColor),
            icon: Icon(
              Typicons.user_outline,
              color: Color(AppData.purpleColor),
            ),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => ProfilePage()),
              );
            },
          ),
          MenuAction(
            name: "เกี่ยวกับโปรแกรม",
            color: Color(AppData.purpleColor),
            icon: Icon(
              Typicons.info_outline,
              color: Color(AppData.purpleColor),
              size: 18,
            ),
            onTap: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => AboutUsPage()),
              );
            },
          ),
          MenuAction(
            name: "ออกจากระบบ",
            color: Color(AppData.purpleColor),
            icon: Icon(
              WebSymbols.logout,
              color: Color(AppData.purpleColor),
              size: 18,
            ),
            onTap: () {
              SweetAlert.show(
                context,
                subtitle: "ออกจากระบบ",
                style: SweetAlertStyle.confirm,
                showCancelButton: true,
                onPress: (bool isConfirm) {
                  Navigator.pop(context);
                  if (isConfirm) {
                    Navigator.pop(context);
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(builder: (context) => LogoutPage()),
                    );
                  }

                  return false;
                },
              );
            },
          ),
        ],
      ),
    );
  }
}

class MenuAction extends StatelessWidget {
  final name;
  final color;
  final icon;
  final trailing;
  final onTap;
  final subMenu;
  final style;

  const MenuAction({
    this.name,
    this.icon,
    this.trailing,
    this.subMenu,
    this.onTap,
    this.color = Colors.white,
    this.style,
    Key key,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Material(
          // color: UIData.greyKssp,
          child: _singleMenu(),
        ),
        // Padding(
        //   padding: EdgeInsets.only(left: 10, right: 10),
        //   child: Divider(
        //     color: Colors.grey.shade300,
        //     height: 10,
        //   ),
        // ),
      ],
    );
  }

  Widget _singleMenu() {
    TextStyle menuStyle = TextStyle(fontSize: 20, color: Color(AppData.purpleColor));
    return InkWell(
      onTap: () {},
      child: ListTile(
        title: Text(
          name,
          overflow: TextOverflow.ellipsis,
          style: style != null ? TextStyle(color: color) : menuStyle,
        ),
        leading: icon,
        trailing: trailing,
        onTap: onTap,
      ),
    );
  }
}
