import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/history_bill_list/history_bill_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/history_bill/history_bill_list.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class HistoryBillPage extends StatefulWidget {
  @override
  _HistoryBillPageState createState() => _HistoryBillPageState();
}

class _HistoryBillPageState extends State<HistoryBillPage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ประวัติการชำระเงิน",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(),
      body: BodyLayout(
        header: CustomerInfo(),
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ประวัติการชำระเงิน",
                  icon: ImageAsset.historyBillImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 90),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            HistoryBillList(),
          ],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<HistoryBillListBloc>().add(HistoryBillListGetList());

    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
