import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/feedback_detail/feedback_detail_bloc.dart';
import 'package:peasmartcare/blocs/feedback_list/feedback_list_bloc.dart';
import 'package:peasmartcare/models/feedback_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/feedback/feedback_detail.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class FeedbackList extends StatefulWidget {
  @override
  _FeedbackListState createState() => _FeedbackListState();
}

class _FeedbackListState extends State<FeedbackList> {
  @override
  void initState() {
    context.read<FeedbackListBloc>().add(FeedbackListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<FeedbackListBloc, FeedbackListState>(
      listener: (context, state) {
        if (state is FeedbackListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<FeedbackListBloc, FeedbackListState>(
        builder: (context, state) {
          if (state is FeedbackListLoading) {
            return Loading();
          } else if (state is FeedbackListLoaded) {
            List<FeedbackModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is FeedbackListNotFound) {
            return NotFoundBox();
          } else if (state is FeedbackListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(FeedbackModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return InkWell(
      child: Container(
        padding: const EdgeInsets.all(5),
        child: Card(
          elevation: 3,
          child: Container(
              padding: EdgeInsets.all(15),
              // height: 100,
              width: deviceSize.width - 40,
              child: Table(
                columnWidths: {1: FixedColumnWidth(30)},
                children: [
                  TableRow(
                    children: [
                      TableCell(
                        child: Table(
                          columnWidths: {0: FixedColumnWidth(130)},
                          children: [
                            TableRow(
                              children: [
                                TableCell(
                                  child: Text("หมายเลขเสียง"),
                                ),
                                TableCell(
                                  child: Text(item.feedbackNumber),
                                ),
                              ],
                            ),
                            TableRow(
                              children: [
                                TableCell(
                                  child: Text("ประเภทเสียงของลูกค้า"),
                                ),
                                TableCell(
                                  child: Text(item.feedbackType),
                                ),
                              ],
                            ),
                            TableRow(
                              children: [
                                TableCell(
                                  child: Text("ประเภทข้อเสนอแนะ/ข้อคิดเห็น"),
                                ),
                                TableCell(
                                  child: Text(item.suggestionType),
                                ),
                              ],
                            ),
                            TableRow(
                              children: [
                                TableCell(
                                  child: Text("การไฟฟ้า"),
                                ),
                                TableCell(
                                  child: Text(item.branch),
                                ),
                              ],
                            ),
                            TableRow(
                              children: [
                                TableCell(
                                  child: Text("วันเวลา"),
                                ),
                                TableCell(
                                  child: Text(item.date),
                                ),
                              ],
                            ),
                            TableRow(
                              children: [
                                TableCell(
                                  child: Text("สถานะ"),
                                ),
                                TableCell(
                                  child: Text(item.status),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                      TableCell(
                        verticalAlignment: TableCellVerticalAlignment.middle,
                        child: Icon(Icons.arrow_forward_ios),
                      ),
                    ],
                  )
                ],
              )),
        ),
      ),
      onTap: () {
        context.read<FeedbackDetailBloc>().add(
              FeedbackDetailAddId(feedbackId: item.id),
            );
        Navigator.push(
          context,
          MaterialPageRoute(builder: (context) => FeedbackDetail()),
        );
      },
    );
  }
}
