import 'package:flutter/material.dart';
import 'package:flutter_map/flutter_map.dart';
import 'package:flutter_map/plugin_api.dart';
import 'package:latlong/latlong.dart';
import 'package:peasmartcare/blocs/electricity_location_save/electricity_location_save_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class SaveLocationPluginOption extends LayerOptions {
  final Alignment alignment;
  final MapController mapController;
  final LatLng currentLatLng;

  SaveLocationPluginOption({
    Key key,
    this.alignment = Alignment.topRight,
    this.mapController,
    this.currentLatLng,
    rebuild,
  }) : super(key: key, rebuild: rebuild);
}

class SaveLocationPlugin implements MapPlugin {
  @override
  Widget createLayer(
      LayerOptions options, MapState mapState, Stream<Null> stream) {
    if (options is SaveLocationPluginOption) {
      return SaveLocationButton(options, mapState, stream);
    }
    throw Exception('Unknown options type for SaveLocationPlugin: $options');
  }

  @override
  bool supportsLayer(LayerOptions options) {
    return options is SaveLocationPluginOption;
  }
}

class SaveLocationButton extends StatelessWidget {
  final SaveLocationPluginOption currentLocationButtonsOpts;
  final MapState map;
  final Stream<Null> stream;
  final FitBoundsOptions options =
      const FitBoundsOptions(padding: EdgeInsets.all(12.0));

  SaveLocationButton(this.currentLocationButtonsOpts, this.map, this.stream)
      : super(key: currentLocationButtonsOpts.key);

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: currentLocationButtonsOpts.alignment,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: <Widget>[
          Padding(
            padding: EdgeInsets.all(8),
            child: RaisedButton(
              padding:
                  EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(7),
              ),
              child: Text(
                "บันทึก",
                style: TextStyle(
                  fontWeight: FontWeight.w800,
                  color: Colors.white,
                  fontSize: 18,
                ),
              ),
              color: Color(AppData.yellowColor),
              onPressed: () {
                LatLng _currentLatLng =
                    currentLocationButtonsOpts.currentLatLng;

                if (_currentLatLng == null ||
                    _currentLatLng.latitude == 0 ||
                    _currentLatLng.longitude == 0) {
                  SweetAlert.show(
                    context,
                    subtitle: "กรุณาทำการปักสถานที่ก่อนการบันทึก",
                    style: SweetAlertStyle.error,
                    showCancelButton: false,
                    onPress: (bool isConfirm) {
                      return true;
                    },
                  );
                } else {
                  context.read<ElectricityLocationSaveBloc>().add(
                        ElectricityLocationSaveOnSubmit(
                          latitude: _currentLatLng.latitude,
                          longitude: _currentLatLng.longitude,
                        ),
                      );
                }
              },
            ),
          ),
        ],
      ),
    );
  }
}
