import 'package:flutter/material.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/models/coordinator_model.dart';
import 'package:peasmartcare/pages/coordinator/coordinator_form.dart';

class CoordinatorAddEdit extends StatefulWidget {
  final CoordinatorModel coordinator;

  const CoordinatorAddEdit({Key key, this.coordinator}) : super(key: key);
  @override
  _CoordinatorAddEditState createState() => _CoordinatorAddEditState();
}

class _CoordinatorAddEditState extends State<CoordinatorAddEdit> {
  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ตัวแทนผู้ประสานงาน",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      body: BodyLayout(
        header: CustomerInfo(),
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ตัวแทนผู้ประสานงาน",
                  icon: ImageAsset.coordinatorImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 50),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            CoordinatorForm(coordinator: widget.coordinator),
          ],
        ),
      ),
    );
  }
}
