import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/coordinator_list/coordinator_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/models/coordinator_model.dart';
import 'package:peasmartcare/pages/coordinator/coordinator_add_edit.dart';
import 'package:peasmartcare/pages/coordinator/coordinator_list.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class CoordinatorPage extends StatefulWidget {
  @override
  _CoordinatorPageState createState() => _CoordinatorPageState();
}

class _CoordinatorPageState extends State<CoordinatorPage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ตัวแทนผู้ประสานงานกับ PEA",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(),
      floatingActionButton: FloatingActionButton(
        onPressed: () {
          Navigator.push(
            context,
            MaterialPageRoute(
              builder: (context) => CoordinatorAddEdit(
                coordinator: CoordinatorModel(),
              ),
            ),
          );
        },
        tooltip: "เพิ่มผู้ประสานงาน",
        child: Icon(Icons.add, color: Color(AppData.whiteColor)),
        backgroundColor: Color(AppData.yellowColor),
      ),
      body: BodyLayout(
        header: CustomerInfo(),
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ตัวแทนผู้ประสานงานกับ PEA",
                  icon: ImageAsset.coordinatorImg,
                  fontSize: 20,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            CoordinatorList(),
          ],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<CoordinatorListBloc>().add(CoordinatorListGetList());

    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
