import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:fluttericon/linearicons_free_icons.dart';
import 'package:peasmartcare/blocs/contact_staff/contact_staff_list_bloc.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/models/contact_staff_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';
import 'package:url_launcher/url_launcher.dart';

class ContactStaffList extends StatefulWidget {
  @override
  _ContactStaffListState createState() => _ContactStaffListState();
}

class _ContactStaffListState extends State<ContactStaffList> {
  @override
  void initState() {
    context.read<ContactStaffListBloc>().add(ContactStaffListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<ContactStaffListBloc, ContactStaffListState>(
      listener: (context, state) {
        if (state is ContactStaffListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<ContactStaffListBloc, ContactStaffListState>(
        builder: (context, state) {
          if (state is ContactStaffListLoading) {
            return Loading();
          } else if (state is ContactStaffListLoaded) {
            List<ContactStaffModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(
                  fullname: item.fullname,
                  phone: item.phone,
                  profileImage: item.profileImage,
                );
              }).toList(),
            );
          } else if (state is ContactStaffListNotFound) {
            return NotFoundBox();
          } else if (state is ContactStaffListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable({String fullname, String phone, String profileImage}) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: InkWell(
        child: Card(
          elevation: 3,
          child: Container(
            padding: EdgeInsets.all(15),
            width: deviceSize.width - 40,
            child: Table(
              columnWidths: {0: FixedColumnWidth(60)},
              children: [
                TableRow(
                  children: [
                    TableCell(
                      child: Container(
                        height: 60,
                        width: 60,
                        child: CircleAvatar(
                          radius: 5,
                          backgroundImage: AssetImage(ImageAsset.imageDefaultAvartar),
                        ),
                      ),
                    ),
                    TableCell(
                      verticalAlignment: TableCellVerticalAlignment.middle,
                      child: Padding(
                        padding: const EdgeInsets.only(left: 15),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              children: [
                                Icon(
                                  LineariconsFree.user_1,
                                  size: 18,
                                ),
                                SizedBox(width: 15),
                                Text(fullname),
                              ],
                            ),
                            SizedBox(height: 10),
                            !AppUtil.isNil(phone)
                                ? Row(
                                    children: [
                                      Icon(
                                        LineariconsFree.phone_handset,
                                        size: 18,
                                      ),
                                      SizedBox(width: 15),
                                      Text(phone ?? ""),
                                    ],
                                  )
                                : EmptyBox(heightFactor: 0),
                          ],
                        ),
                      ),
                    ),
                    // TableCell(
                    //   verticalAlignment: TableCellVerticalAlignment.middle,
                    //   child: Row(
                    //     children: [
                    //       phone != null
                    //           ? Icon(
                    //               LineariconsFree.phone_handset,
                    //               size: 18,
                    //             )
                    //           : EmptyBox(heightFactor: 0),
                    //       SizedBox(width: 15),
                    //       Text(phone ?? ""),
                    //     ],
                    //   ),
                    // ),
                  ],
                ),
              ],
            ),
          ),
        ),
        onTap: () {
          if (phone != null) {
            launch("tel://$phone");
          }
        },
      ),
    );
  }
}
