import 'package:flutter/material.dart';
import 'package:peasmartcare/components/chat/chat.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/utils/clear_count_notification_util.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

class SingleChat extends StatefulWidget {
  final String fullname;
  final String typeChat;
  final String chatMasterId;
  final String typeAccount;

  const SingleChat({
    Key key,
    this.fullname,
    this.typeChat,
    this.chatMasterId,
    this.typeAccount,
  }) : super(key: key);
  @override
  _SingleChatState createState() => _SingleChatState();
}

class _SingleChatState extends State<SingleChat> {
  @override
  void initState() {
    ClearCountNotificationUtil.chat(widget.chatMasterId);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        // title: widget.fullname ?? "",
        title: "พนักงานดูแลลูกค้า",
        actions: <Widget>[
          ProfileAvatar(),
        ],
        leading: IconButton(
          icon: Icon(Icons.arrow_back_ios),
          onPressed: () {
            Navigator.pop(context);
            ClearCountNotificationUtil.chat(widget.chatMasterId);
          },
          tooltip: MaterialLocalizations.of(context).openAppDrawerTooltip,
        ),
      ),
      body: Chat(
        userId: ShareDataUtil.getUserId(),
        isGroupChat: false,
        typeChat: widget.typeChat,
        chatMasterId: widget.chatMasterId,
        typeAccount: widget.typeAccount,
      ),
    );
  }
}
