import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/chat_reader_list/chat_reader_list_bloc.dart';
import 'package:peasmartcare/models/chat_reader_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/loading.dart';

class ChatReaderList extends StatefulWidget {
  final ScrollController scrollController;
  final String id;

  const ChatReaderList({Key key, this.scrollController, this.id}) : super(key: key);

  @override
  _ChatReaderListState createState() => _ChatReaderListState();
}

class _ChatReaderListState extends State<ChatReaderList> {
  @override
  void initState() {
    if (!AppUtil.isNil(widget.id)) {
      context.read<ChatReaderListBloc>().add(ChatReaderListGetList(messageId: widget.id));
    }

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Material(
      child: CupertinoPageScaffold(
        navigationBar: CupertinoNavigationBar(leading: Container(), middle: Text('อ่านแล้ว')),
        child: SafeArea(
          bottom: false,
          child: BlocListener<ChatReaderListBloc, ChatReaderListState>(
            listener: (context, state) {
              if (state is ChatReaderListErrorUnauthorized) {
                Navigator.of(context).popUntil((route) => route.isFirst);
                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(builder: (context) => LogoutPage()),
                );
              }
            },
            child: BlocBuilder<ChatReaderListBloc, ChatReaderListState>(
              builder: (context, state) {
                if (state is ChatReaderListLoading) {
                  return Loading();
                } else if (state is ChatReaderListLoaded) {
                  List<ChatReaderModel> itemList = state.result;
                  return Container(
                    constraints: BoxConstraints(
                      minHeight: deviceSize.height / 3,
                    ),
                    child: ListView(
                      shrinkWrap: true,
                      controller: widget.scrollController,
                      children: ListTile.divideTiles(
                        color: Colors.grey[300],
                        context: context,
                        tiles: List.generate(
                            itemList?.length ?? 0,
                            (index) => ListTile(
                                  title: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      Text(itemList[index].companyName ?? ""),
                                      Text("${(itemList[index].username ?? "")} ${(itemList[index].createDate ?? "")}"),
                                    ],
                                  ),
                                )),
                      ).toList(),
                    ),
                  );
                }

                return EmptyBox(heightFactor: 10);
              },
            ),
          ),
          // child: ListView(
          //   shrinkWrap: true,
          //   controller: widget.scrollController,
          //   children: ListTile.divideTiles(
          //     context: context,
          //     tiles: List.generate(
          //         6,
          //         (index) => ListTile(
          //               title: Text('Item'),
          //             )),
          //   ).toList(),
          // ),
        ),
      ),
    );
  }
}
