import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/login/login_bloc.dart';
import 'package:peasmartcare/blocs/resend_otp/resend_otp_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/auth/register.dart';
import 'package:peasmartcare/pages/auth/send_otp.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class LoginPage extends StatefulWidget {
  @override
  _LoginPageState createState() => _LoginPageState();
}

class _LoginPageState extends State<LoginPage> {
  final _formKey = GlobalKey<FormState>();
  TextEditingController _fullname = TextEditingController();
  TextEditingController _idCard = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: BodyLayout(
        layoutType: LayoutType.ONLY_CHILD,
        color: Colors.purple[100],
        top: 80,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Form(
      key: _formKey,
      child: Positioned(
        child: Padding(
          padding: const EdgeInsets.only(top: 0),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                alignment: Alignment.topCenter,
                child: Image.asset(
                  ImageAsset.peaSmartCareLogo,
                  height: 250,
                  fit: BoxFit.fill,
                ),
              ),
              SizedBox(
                height: 20,
              ),
              Padding(
                padding: EdgeInsets.symmetric(horizontal: 32),
                child: Material(
                  elevation: 2.0,
                  borderRadius: BorderRadius.all(Radius.circular(30)),
                  child: TextField(
                    controller: _fullname,
                    onChanged: (String value) {},
                    cursorColor: Color(AppData.yellowColor),
                    style: TextStyle(color: Color(AppData.primaryColor)),
                    decoration: InputDecoration(
                      hintText: "ชื่อ - นามสกุล",
                      hintStyle: TextStyle(color: Color(AppData.primaryColor)),
                      prefixIcon: Material(
                        elevation: 0,
                        borderRadius: BorderRadius.all(Radius.circular(30)),
                        child: Icon(
                          Icons.account_box,
                          color: Color(AppData.purpleColor),
                        ),
                      ),
                      border: InputBorder.none,
                      contentPadding:
                          EdgeInsets.symmetric(horizontal: 25, vertical: 13),
                    ),
                  ),
                ),
              ),
              SizedBox(
                height: 20,
              ),
              Padding(
                padding: EdgeInsets.symmetric(horizontal: 32),
                child: Material(
                  elevation: 2.0,
                  borderRadius: BorderRadius.all(Radius.circular(30)),
                  child: TextField(
                    controller: _idCard,
                    onChanged: (String value) {},
                    cursorColor: Color(AppData.yellowColor),
                    style: TextStyle(color: Color(AppData.primaryColor)),
                    decoration: InputDecoration(
                        hintText: "บัตรประชาชน",
                        hintStyle:
                            TextStyle(color: Color(AppData.primaryColor)),
                        prefixIcon: Material(
                          elevation: 0,
                          borderRadius: BorderRadius.all(Radius.circular(30)),
                          child: Icon(
                            Icons.lock,
                            color: Color(AppData.purpleColor),
                          ),
                        ),
                        border: InputBorder.none,
                        contentPadding:
                            EdgeInsets.symmetric(horizontal: 25, vertical: 13)),
                  ),
                ),
              ),
              SizedBox(
                height: 25,
              ),
              BlocListener<LoginBloc, LoginState>(
                listener: (context, state) {
                  if (state is LoginLoaded) {
                    if (state.result) {
                      // Navigator.pushReplacement(
                      //   context,
                      //   MaterialPageRoute(builder: (context) => HomePage()),
                      // );
                      // Navigator.pushReplacement(
                      //   context,
                      //   MaterialPageRoute(builder: (context) => SelectElectricityLocationPage()),
                      // );
                      print("state.otpResult ${state.otpResult}");
                      context.read<ResendOtpBloc>().add(
                            ResendOtpAddPhone(phoneNumber: state.phoneNumber),
                          );
                      Navigator.pushReplacement(
                        context,
                        MaterialPageRoute(
                          builder: (context) => SendOTPPage(
                            phoneNumber: state.phoneNumber,
                            otpData: state.otpResult,
                          ),
                        ),
                      );
                    } else {
                      SweetAlert.show(
                        context,
                        subtitle: "ชื่อ - นามสกุล หรือบัตรประชาชนไม่ถูกต้อง",
                        style: SweetAlertStyle.error,
                      );
                    }
                  } else if (state is LoginError) {
                    // print("okkkk ${state.message}");
                    SweetAlert.show(
                      context,
                      subtitle: state.message,
                      style: SweetAlertStyle.error,
                    );
                  }
                },
                child: BlocBuilder<LoginBloc, LoginState>(
                  builder: (context, state) {
                    if (state is LoginLoading) {
                      return Loading(height: 50);
                    }
                    return Padding(
                      padding: EdgeInsets.symmetric(horizontal: 32),
                      child: Container(
                        width: double.infinity,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.all(Radius.circular(100)),
                          color: Color(AppData.yellowColor),
                        ),
                        child: FlatButton(
                          child: Text(
                            "เข้าสู่ระบบ",
                            style: TextStyle(
                                color: Color(AppData.primaryColor),
                                fontWeight: FontWeight.w700,
                                fontSize: 18),
                          ),
                          onPressed: () {
                            String fullname = _fullname.text;
                            String idCard = _idCard.text;

                            context.read<LoginBloc>().add(
                                  LoginOnSubmit(
                                      fullname: fullname, idCard: idCard),
                                );
                          },
                        ),
                      ),
                    );
                  },
                ),
              ),
              SizedBox(
                height: 40,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Text(
                    "ยังไม่มีบัญชีผู้ใช้งาน ",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: 18,
                        fontWeight: FontWeight.normal),
                  ),
                  GestureDetector(
                    onTap: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => RegisterPage()),
                      );
                      // Navigator.push(
                      //   context,
                      //   MaterialPageRoute(builder: (context) => SendOTPPage()),
                      // );
                    },
                    child: Text(
                      "สมัครสมาชิก",
                      style: TextStyle(
                          color: Color(AppData.primaryColor),
                          fontWeight: FontWeight.w500,
                          fontSize: 18,
                          decoration: TextDecoration.underline),
                    ),
                  ),
                ],
              )
            ],
          ),
        ),
      ),
    );
  }
}
