import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/authen/authen_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/connection_fail.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/auth/register.dart';
import 'package:peasmartcare/pages/home/home.dart';
import 'package:peasmartcare/widgets/error_box.dart';

class AuthenPage extends StatefulWidget {
  @override
  _AuthenPageState createState() => _AuthenPageState();
}

class _AuthenPageState extends State<AuthenPage> {
  @override
  void initState() {
    context.read<AuthenBloc>().add(AuthenOnDefault());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return _body();
  }

  Widget _body() {
    Size deviceSize = MediaQuery.of(context).size;
    return BlocListener<AuthenBloc, AuthenState>(
      listener: (context, state) {
        if (state is AuthenLoaded) {
          if (state.isLogin) {
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => HomePage()),
            );
          } else {
            Navigator.pushReplacement(
              context,
              // MaterialPageRoute(builder: (context) => LoginPage()),
              MaterialPageRoute(builder: (context) => RegisterPage()),
            );
          }
        } else if (state is AuthenErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        } else if (state is AuthenError) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => ConnectionFailPage()),
          );
        }
      },
      child: BlocBuilder<AuthenBloc, AuthenState>(
        builder: (context, state) {
          // if (state is AuthenError) {
          //   return Scaffold(
          //     body: BodyLayout(
          //       layoutType: LayoutType.ONLY_CHILD,
          //       color: Colors.purple[100],
          //       top: 80,
          //       child: Text("ssss"),
          //     ),
          //   );
          //   // return Container(
          //   //   height: deviceSize.height,
          //   //   child: ErrorBox(
          //   //     message: state.message,
          //   //   ),
          //   // );
          // }
          return Stack(
            fit: StackFit.expand,
            children: <Widget>[
              Container(
                alignment: Alignment.topCenter,
                child: Image.asset(
                  ImageAsset.bgSplashScreen,
                  height: deviceSize.height,
                  width: deviceSize.width,
                  fit: BoxFit.fill,
                ),
              ),
              Column(
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Expanded(
                    flex: 1,
                    child: Container(
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: <Widget>[
                          Container(
                            alignment: Alignment.topCenter,
                            child: Image.asset(
                              ImageAsset.peaSmartCareLogo,
                              height: 250,
                              // width: deviceSize.width,
                              fit: BoxFit.fill,
                            ),
                          ),
                          Padding(
                            padding: EdgeInsets.only(top: 10),
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              )
            ],
          );
        },
      ),
    );
  }
}
