class UserModel {
  String id;
  String firstname;
  String lastname;
  String idCard;
  String employeeId;
  String username;
  bool loginStatus;
  String phone;
  String authenKey;

  UserModel({
    this.id,
    this.firstname,
    this.lastname,
    this.idCard,
    this.employeeId,
    this.username,
    this.loginStatus,
    this.phone,
    this.authenKey,
  });

  factory UserModel.fromJson(Map<String, dynamic> json) => UserModel(
        id: json["UserID"],
        firstname: json["FirstName"],
        lastname: json["LastName"],
        idCard: json["IDCard"],
        employeeId: json["EmployeeID"],
        username: json["UserName"],
        loginStatus: json["LoginStatus"] == 0 ? false : true,
        phone: json["Mobile"],
        authenKey: json["Authenkey"],
      );

  Map<String, dynamic> toJson() => {
        "UserID": id,
        "FirstName": firstname,
        "LastName": lastname,
        "IDCard": idCard,
        "EmployeeID": employeeId,
        "UserName": username,
        "LoginStatus": loginStatus ? 1 : 0,
        "Mobile": phone,
        "Authenkey": authenKey,
      };
}
