class SurveyModel {
  String id;
  String srcqId;
  String srcqSequence;
  String createBy;
  String createDate;

  SurveyModel({
    this.id,
    this.srcqId,
    this.srcqSequence,
    this.createBy,
    this.createDate,
  });

  factory SurveyModel.fromJson(Map<String, dynamic> json) => SurveyModel(
        id: json["SQ_Id"] ?? "",
        srcqId: json["SRCQ_Id"] ?? "",
        srcqSequence: (json["SRCQ_Sequence"] ?? 0).toString(),
        createBy: json["CreateBy"] ?? "",
        createDate: json["CreateDate"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "SQ_Id": id,
        "SRCQ_Id": srcqId,
        "SRCQ_Sequence": srcqSequence,
        "CreateBy": createBy,
        "CreateDate": createDate,
      };
}
