class ReportIncidentPlanModel {
  String startDate;
  String endDate;
  String detail;
  String informantCompany;
  String informant;
  String phone;

  ReportIncidentPlanModel({
    this.startDate,
    this.endDate,
    this.detail,
    this.informantCompany,
    this.informant,
    this.phone,
  });

  factory ReportIncidentPlanModel.fromJson(Map<String, dynamic> json) => ReportIncidentPlanModel(
        startDate: json["ShutdownStartDate"]??"",
        endDate: json["ShutdownEndDate"]??"",
        detail: json["ShutdownDetail"]??"",
        informantCompany: json["informantCompany"]??"",
        informant: json["informant"]??"",
        phone: json["phone"]??"",
      );

  Map<String, dynamic> toJson() => {
        "ShutdownStartDate": startDate,
        "ShutdownEndDate": endDate,
        "ShutdownDetail": detail,
        "informantCompany": informantCompany,
        "informant": informant,
        "phone": phone,
      };
}
