class ReportIncidentHistoryModel {
  String startDate;
  String endDate;
  String detailType;
  String detail;
  String informantCompany;
  String informant;
  String phone;

  ReportIncidentHistoryModel({
    this.startDate,
    this.endDate,
    this.detailType,
    this.detail,
    this.informantCompany,
    this.informant,
    this.phone,
  });

  factory ReportIncidentHistoryModel.fromJson(Map<String, dynamic> json) => ReportIncidentHistoryModel(
        startDate: json["ProblemStartDate"] ?? "",
        endDate: json["ProblemEndDate"] ?? "",
        detailType: json["detailType"] ?? "",
        detail: json["ProblemDetail"] ?? "",
        informantCompany: json["informantCompany"] ?? "",
        informant: json["PersonInform"] ?? "",
        phone: json["phone"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "ProblemStartDate": startDate,
        "ProblemEndDate": endDate,
        "detailType": detailType,
        "ProblemDetail": detail,
        "informantCompany": informantCompany,
        "PersonInform": informant,
        "phone": phone,
      };
}
