import 'package:peasmartcare/models/questionnaire_choice_model.dart';

class QuestionnaireQuestionModel {
  String id;
  String questionnaireId;
  String question;
  int type;
  List<QuestionnaireChoiceModel> choiceList;

  QuestionnaireQuestionModel({
    this.id,
    this.questionnaireId,
    this.question,
    this.type,
    this.choiceList,
  });

  factory QuestionnaireQuestionModel.fromJson(Map<String, dynamic> json) => QuestionnaireQuestionModel(
        id: json["RQD_Id"] ?? "",
        questionnaireId: json["RQ_Id"] ?? "",
        question: json["RQD_Question"] ?? "",
        type: json["RQD_Type"] ?? "",
        choiceList: List<QuestionnaireChoiceModel>.from(json["QuestionChoice"].map((x) => QuestionnaireChoiceModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "RQD_Id": id,
        "RQ_Id": questionnaireId,
        "RQD_Question": question,
        "type": type,
        "QuestionChoice": List<dynamic>.from(choiceList.map((x) => x.toJson())),
      };
}
