class QuestionnaireModel {
  String id;
  String subject;
  String description;
  String startDate;
  String endDate;

  QuestionnaireModel({
    this.id,
    this.subject,
    this.description,
    this.startDate,
    this.endDate,
  });

  factory QuestionnaireModel.fromJson(Map<String, dynamic> json) => QuestionnaireModel(
        id: json["RQ_Id"] ?? "",
        subject: json["RQ_Name"] ?? "",
        description: json["RQ_Description"] ?? "",
        startDate: json["StartDate"] ?? "",
        endDate: json["EndDate"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "RQ_Id": id,
        "RQ_Name": subject,
        "RQ_Description": description,
        "StartDate": startDate,
        "EndDate": endDate,
      };
}
